/**
   This is a regular tetrahedron with side length 1.
   One face is in the xz-plane, with its center at the orgin.
   The 4th vertex in on the positive y-axis.

   http://en.wikipedia.org/wiki/Tetrahedron


                     (1, 0, -1/sqrt(2)) (0, 1, 1/sqrt(2)) edge length 2

                     (sqrt(2), 0, -1)   (0, sqrt(2), 1)   edge length 2*sqrt(2)

                     ( 0, 0, 0)  ( 1, 1, 0)  ( 0, 1, 1)  ( 1, 0, 1)  edge length sqrt(2)
        Tetrahedron: ( 1,-1,-1)  (-1, 1,-1)  ( 1, 1, 1)  (-1,-1, 1)  edge length 2*sqrt(2)
   Dual Tetrahedron: (-1, 1, 1)  ( 1,-1, 1)  (-1,-1,-1)  ( 1, 1,-1)
*/

public class TetrahedronModel extends Model
{
   public TetrahedronModel()
   {
      super();

      // Create the tetrahedron's geometry.
      double sqrt3 = Math.sqrt(3.0);
      double sqrt2 = Math.sqrt(2.0);
      Vertex[] v = new Vertex[4];
      v[0] = new Vertex( 1/sqrt3,     0,  0);    // three vertices around the bottom face
      v[1] = new Vertex(-1/(2*sqrt3), 0,  0.5);
      v[2] = new Vertex(-1/(2*sqrt3), 0, -0.5);
      v[3] = new Vertex( 0, sqrt2/sqrt3,  0);    // vertex at the top

      // Create 6 line segments.
      LineSegment[] ls = new LineSegment[6];

      int i = 0;
      // bottom face
      ls[i++] = new LineSegment(v[0], v[1]);
      ls[i++] = new LineSegment(v[1], v[2]);
      ls[i++] = new LineSegment(v[2], v[0]);

      // edge 1
      ls[i++] = new LineSegment(v[0], v[3]);

      // edge 2
      ls[i++] = new LineSegment(v[1], v[3]);

      // edge 3
      ls[i++] = new LineSegment(v[2], v[3]);

      // Add the new line segments to the model.
      for (i = 0; i < ls.length; i++)
      {
         this.addLineSegment( ls[i] );
      }
   }
}//TetrahedronModel