/**
                   y
                   |
                   |
              v[0] + a
                  /| \
                 / |   \
                /  |     \
               /   |       \
              /    |         \
             /     |           \
            /      |             \
      v[1] /       |               \ v[2]
      ----+--------------------------+------ x
           b      /                  c
                /
              /
            /
          /
        z

   This model represents a triangle in the xy-plane
   with its first vertex on the y-axis and its other
   two vertices on the x-axis. You can easily model
   any shape of triangle this way.
*/

public class TriangleModel extends Model
{
   double a;
   double b;
   double c;

   public TriangleModel()
   {
      this(1, -1, 1);
   }


   public TriangleModel(double a, double b, double c)
   {
      super();

      this.a = a;
      this.b = b;
      this.c = c;

      // Create the triangle's geometry.
      Vertex[] v = new Vertex[3];
      v[0] = new Vertex(0, a, 0); // three vertices around the triangle
      v[1] = new Vertex(b, 0, 0);
      v[2] = new Vertex(c, 0, 0);

      // Create 3 line segments.
      LineSegment[] ls = new LineSegment[3];
      int i = 0;
      ls[i++] = new LineSegment(v[0], v[1]);
      ls[i++] = new LineSegment(v[1], v[2]);
      ls[i++] = new LineSegment(v[2], v[0]);

      // Add the line segments to the model.
      for (i = 0; i < ls.length; i++)
      {
         this.addLineSegment( ls[i] );
      }
   }
}//TriangleModel