/*
 * Decompiled with CFR 0.152.
 */
package framebuffer;

import java.awt.Color;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FrameBuffer {
    private Color bgColorFB;
    private int width;
    private int height;
    protected int[] pixel_buffer;
    private int vp_ul_x;
    private int vp_ul_y;
    private int vp_lr_x;
    private int vp_lr_y;
    private Color bgColorVP;

    public FrameBuffer(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.vp_ul_x = 0;
        this.vp_ul_y = 0;
        this.vp_lr_x = this.width - 1;
        this.vp_lr_y = this.height - 1;
        this.pixel_buffer = new int[this.width * this.height];
        this.clearFB(Color.black);
        this.bgColorFB = Color.black;
        this.bgColorVP = Color.black;
    }

    public FrameBuffer(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            String string2 = "";
            char c = (char)fileInputStream.read();
            while (c != '\n') {
                string2 = string2 + c;
                c = (char)fileInputStream.read();
            }
            if (!string2.trim().startsWith("P6")) {
                System.err.printf("ERROR! Improper PPM number in file %s\n", string);
                System.exit(-1);
            }
            if ('#' == (c = (char)fileInputStream.read())) {
                while (c != '\n') {
                    c = (char)fileInputStream.read();
                }
                c = (char)fileInputStream.read();
            }
            String string3 = "";
            while (c != ' ' && c != '\n') {
                string3 = string3 + c;
                c = (char)fileInputStream.read();
            }
            String string4 = "";
            c = (char)fileInputStream.read();
            while (c != '\n') {
                string4 = string4 + c;
                c = (char)fileInputStream.read();
            }
            fileInputStream.close();
            this.width = Integer.parseInt(string3.trim());
            this.height = Integer.parseInt(string4.trim());
            this.vp_ul_x = 0;
            this.vp_ul_y = 0;
            this.vp_lr_x = this.width - 1;
            this.vp_lr_y = this.height - 1;
            this.pixel_buffer = new int[this.width * this.height];
            this.clearFB(Color.black);
            this.bgColorFB = Color.black;
            this.bgColorVP = Color.black;
            this.setViewport(this.vp_ul_x, this.vp_ul_y, string);
        }
        catch (IOException iOException) {
            System.err.printf("ERROR! Could not read %s\n", string);
            iOException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public int getWidthFB() {
        return this.width;
    }

    public int getHeightFB() {
        return this.height;
    }

    public Color getBgColorFB() {
        return this.bgColorFB;
    }

    public void clearFB(Color color) {
        this.bgColorFB = color;
        this.bgColorVP = color;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.setPixelFB(j, i, color);
            }
        }
    }

    public Color getPixelFB(int n, int n2) {
        int n3 = n2 * this.width + n;
        try {
            int n4 = this.pixel_buffer[n3];
            return new Color(n4);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("FrameBuffer: Bad pixel coordinate (" + n + ", " + n2 + ")");
            return Color.black;
        }
    }

    public void setPixelFB(int n, int n2, Color color) {
        int n3 = n2 * this.width + n;
        try {
            this.pixel_buffer[n3] = color.getRGB();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("FrameBuffer: Bad pixel coordinate (" + n + ", " + n2 + ")");
        }
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.vp_ul_x = n;
        this.vp_ul_y = n2;
        this.vp_lr_x = n + n3 - 1;
        this.vp_lr_y = n2 + n4 - 1;
    }

    public void setViewport(int n, int n2, FrameBuffer frameBuffer) {
        int n3 = frameBuffer.width;
        int n4 = frameBuffer.height;
        this.vp_ul_x = n;
        this.vp_ul_y = n2;
        this.vp_lr_x = n + n3 - 1;
        this.vp_lr_y = n2 + n4 - 1;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.setPixelVP(j, i, frameBuffer.getPixelFB(j, i));
            }
        }
    }

    public void setViewport(int n, int n2, String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            String string2 = "";
            char c = (char)fileInputStream.read();
            while (c != '\n') {
                string2 = string2 + c;
                c = (char)fileInputStream.read();
            }
            if (!string2.trim().startsWith("P6")) {
                System.err.printf("ERROR! Improper PPM number in file %s\n", string);
                System.exit(-1);
            }
            if ('#' == (c = (char)fileInputStream.read())) {
                while (c != '\n') {
                    c = (char)fileInputStream.read();
                }
                c = (char)fileInputStream.read();
            }
            String string3 = "";
            while (c != ' ' && c != '\n') {
                string3 = string3 + c;
                c = (char)fileInputStream.read();
            }
            String string4 = "";
            c = (char)fileInputStream.read();
            while (c != '\n') {
                string4 = string4 + c;
                c = (char)fileInputStream.read();
            }
            c = (char)fileInputStream.read();
            while (c != '\n') {
                c = (char)fileInputStream.read();
            }
            int n3 = Integer.parseInt(string3.trim());
            int n4 = Integer.parseInt(string4.trim());
            this.vp_ul_x = n;
            this.vp_ul_y = n2;
            this.vp_lr_x = n + n3 - 1;
            this.vp_lr_y = n2 + n4 - 1;
            byte[] byArray = new byte[3];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (fileInputStream.read(byArray, 0, 3) != 3) {
                        System.err.printf("ERROR! Could not load %s\n", string);
                        System.exit(-1);
                    }
                    int n5 = byArray[0];
                    int n6 = byArray[1];
                    int n7 = byArray[2];
                    if (n5 < 0) {
                        n5 = 256 + n5;
                    }
                    if (n6 < 0) {
                        n6 = 256 + n6;
                    }
                    if (n7 < 0) {
                        n7 = 256 + n7;
                    }
                    this.setPixelVP(j, i, new Color(n5, n6, n7));
                }
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.err.printf("ERROR! Could not read %s\n", string);
            iOException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public int getWidthVP() {
        return this.vp_lr_x - this.vp_ul_x + 1;
    }

    public int getHeightVP() {
        return this.vp_lr_y - this.vp_ul_y + 1;
    }

    public Point getLocationVP() {
        return new Point(this.vp_ul_x, this.vp_ul_y);
    }

    public Color getBgColorVP() {
        return this.bgColorVP;
    }

    public void clearVP(Color color) {
        this.bgColorVP = color;
        int n = this.getWidthVP();
        int n2 = this.getHeightVP();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.setPixelVP(j, i, color);
            }
        }
    }

    public Color getPixelVP(int n, int n2) {
        return this.getPixelFB(this.vp_ul_x + n, this.vp_ul_y + n2);
    }

    public void setPixelVP(int n, int n2, Color color) {
        this.setPixelFB(this.vp_ul_x + n, this.vp_ul_y + n2, color);
    }

    public FrameBuffer convertVP2FB() {
        int n = this.getWidthVP();
        int n2 = this.getHeightVP();
        FrameBuffer frameBuffer = new FrameBuffer(n, n2);
        frameBuffer.bgColorFB = this.bgColorVP;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                frameBuffer.setPixelFB(j, i, this.getPixelVP(j, i));
            }
        }
        return frameBuffer;
    }

    public FrameBuffer convertRed2FB() {
        FrameBuffer frameBuffer = new FrameBuffer(this.width, this.height);
        frameBuffer.bgColorFB = this.bgColorFB;
        frameBuffer.bgColorVP = this.bgColorVP;
        frameBuffer.vp_ul_x = this.vp_ul_x;
        frameBuffer.vp_ul_y = this.vp_ul_y;
        frameBuffer.vp_lr_x = this.vp_lr_x;
        frameBuffer.vp_lr_y = this.vp_lr_y;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                Color color = new Color(this.getPixelFB(j, i).getRed(), 0, 0);
                frameBuffer.setPixelFB(j, i, color);
            }
        }
        return frameBuffer;
    }

    public FrameBuffer convertGreen2FB() {
        FrameBuffer frameBuffer = new FrameBuffer(this.width, this.height);
        frameBuffer.bgColorFB = this.bgColorFB;
        frameBuffer.bgColorVP = this.bgColorVP;
        frameBuffer.vp_ul_x = this.vp_ul_x;
        frameBuffer.vp_ul_y = this.vp_ul_y;
        frameBuffer.vp_lr_x = this.vp_lr_x;
        frameBuffer.vp_lr_y = this.vp_lr_y;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                Color color = new Color(0, this.getPixelFB(j, i).getGreen(), 0);
                frameBuffer.setPixelFB(j, i, color);
            }
        }
        return frameBuffer;
    }

    public FrameBuffer convertBlue2FB() {
        FrameBuffer frameBuffer = new FrameBuffer(this.width, this.height);
        frameBuffer.bgColorFB = this.bgColorFB;
        frameBuffer.bgColorVP = this.bgColorVP;
        frameBuffer.vp_ul_x = this.vp_ul_x;
        frameBuffer.vp_ul_y = this.vp_ul_y;
        frameBuffer.vp_lr_x = this.vp_lr_x;
        frameBuffer.vp_lr_y = this.vp_lr_y;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                Color color = new Color(0, 0, this.getPixelFB(j, i).getBlue());
                frameBuffer.setPixelFB(j, i, color);
            }
        }
        return frameBuffer;
    }

    public void dumpFB2File(String string) {
        this.dumpPixels2File(0, 0, this.width - 1, this.height - 1, string);
    }

    public void dumpVP2File(String string) {
        this.dumpPixels2File(this.vp_ul_x, this.vp_ul_y, this.vp_lr_x, this.vp_lr_y, string);
    }

    public void dumpPixels2File(int n, int n2, int n3, int n4, String string) {
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.printf("ERROR! Could not open file %s\n", string);
            fileNotFoundException.printStackTrace(System.err);
            System.exit(-1);
        }
        try {
            fileOutputStream.write(("P6\n" + n5 + " " + n6 + "\n" + 255 + "\n").getBytes());
            byte[] byArray = new byte[n5 * 3];
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < byArray.length; j += 3) {
                    int n7 = this.pixel_buffer[(n2 + i) * this.width + n + j / 3];
                    Color color = new Color(n7);
                    byArray[j + 0] = (byte)color.getRed();
                    byArray[j + 1] = (byte)color.getGreen();
                    byArray[j + 2] = (byte)color.getBlue();
                }
                fileOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            System.err.printf("ERROR! Could not write to file %s\n", string);
            iOException.printStackTrace(System.err);
            System.exit(-1);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.printf("ERROR! Could not close file %s\n", string);
            iOException.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public void fbTest() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n = (j | i) % 255;
                this.setPixelFB(j, i, new Color(n, n, n));
            }
        }
    }

    public void vpTest() {
        for (int i = 0; i < this.getHeightVP(); ++i) {
            for (int j = 0; j < this.getWidthVP(); ++j) {
                int n = (j | i) % 255;
                this.setPixelVP(j, i, new Color(n, n, n));
            }
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 512;
        int n3 = 512;
        FrameBuffer frameBuffer = new FrameBuffer(n2, n3);
        frameBuffer.fbTest();
        frameBuffer.dumpFB2File("test01.ppm");
        frameBuffer.setViewport(64, 64, 192, 320);
        frameBuffer.clearVP(Color.red);
        for (n = 0; n < 512; ++n) {
            frameBuffer.setPixelFB(128, n, Color.blue);
        }
        for (n = 0; n < 192; ++n) {
            frameBuffer.setPixelVP(n, n, Color.green);
        }
        frameBuffer.dumpFB2File("test02.ppm");
        frameBuffer.dumpVP2File("test03.ppm");
        frameBuffer.dumpPixels2File(32, 192, 447, 319, "test04.ppm");
        frameBuffer.setViewport(80, 80, 160, 160);
        frameBuffer.vpTest();
        frameBuffer.dumpFB2File("test05.ppm");
        FrameBuffer frameBuffer2 = new FrameBuffer("test05.ppm");
        frameBuffer2.dumpFB2File("test06.ppm");
        frameBuffer.convertRed2FB().dumpFB2File("test07.ppm");
        frameBuffer.convertGreen2FB().dumpFB2File("test08.ppm");
        frameBuffer.convertBlue2FB().dumpFB2File("test09.ppm");
        frameBuffer.convertBlue2FB().convertVP2FB().dumpFB2File("test10.ppm");
        FrameBuffer frameBuffer3 = new FrameBuffer(600, 600);
        frameBuffer3.clearFB(Color.orange);
        frameBuffer3.setViewport(44, 44, "test05.ppm");
        frameBuffer3.dumpFB2File("test11.ppm");
        frameBuffer3.setViewport(86, 86, frameBuffer3.convertVP2FB());
        frameBuffer3.dumpFB2File("test12.ppm");
    }
}

