/*
 * Decompiled with CFR 0.152.
 */
package framebuffer;

import framebuffer.FrameBuffer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class InteractiveFrame
extends JFrame
implements FocusListener,
ComponentListener,
WindowListener,
ActionListener,
ItemListener,
AdjustmentListener,
TextListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private FrameBuffer fb;
    private MemoryImageSource source;
    private Image img;

    public InteractiveFrame(String string, int n, int n2) {
        super(string);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(3);
        this.setSize(n, n2);
        this.setVisible(true);
        Insets insets = this.getInsets();
        this.setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
        this.createFrameBuffer(n, n2);
        this.setContentPane(new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                InteractiveFrame.this.source.newPixels(0, 0, InteractiveFrame.this.fb.getWidthFB(), InteractiveFrame.this.fb.getHeightFB());
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.drawImage(InteractiveFrame.this.img, 0, 0, this);
                graphics2D.dispose();
            }
        });
    }

    public FrameBuffer getFrameBuffer() {
        return this.fb;
    }

    public void createFrameBuffer(int n, int n2) {
        this.fb = new FrameBuffer(n, n2);
        this.source = new MemoryImageSource(this.fb.getWidthFB(), this.fb.getHeightFB(), this.fb.pixel_buffer, 0, this.fb.getWidthFB());
        this.source.setAnimated(true);
        this.img = this.createImage(this.source);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }
}

