/*
 * Decompiled with CFR 0.152.
 */
package pipeline;

import scene.LineSegment;
import scene.Vertex;

public class Clip {
    public static boolean clip(LineSegment lineSegment) {
        Vertex vertex = lineSegment.v[0];
        Vertex vertex2 = lineSegment.v[1];
        double d = vertex.x;
        double d2 = vertex2.x;
        double d3 = vertex.y;
        double d4 = vertex2.y;
        if (!(Math.abs(d) > 1.0 || Math.abs(d3) > 1.0 || Math.abs(d2) > 1.0 || Math.abs(d4) > 1.0)) {
            return true;
        }
        if (d > 1.0 && d2 > 1.0 || d < -1.0 && d2 < -1.0 || d3 > 1.0 && d4 > 1.0 || d3 < -1.0 && d4 < -1.0) {
            return false;
        }
        if (d > 1.0 || d2 > 1.0) {
            if (d2 > 1.0) {
                Vertex vertex3;
                lineSegment.v[1] = vertex3 = Clip.interpolateNewVertex(vertex, vertex2, 1);
            } else {
                Vertex vertex4;
                lineSegment.v[0] = vertex4 = Clip.interpolateNewVertex(vertex2, vertex, 1);
            }
        } else if (d < -1.0 || d2 < -1.0) {
            if (d2 < -1.0) {
                Vertex vertex5;
                lineSegment.v[1] = vertex5 = Clip.interpolateNewVertex(vertex, vertex2, 2);
            } else {
                Vertex vertex6;
                lineSegment.v[0] = vertex6 = Clip.interpolateNewVertex(vertex2, vertex, 2);
            }
        } else if (d3 > 1.0 || d4 > 1.0) {
            if (d4 > 1.0) {
                Vertex vertex7;
                lineSegment.v[1] = vertex7 = Clip.interpolateNewVertex(vertex, vertex2, 3);
            } else {
                Vertex vertex8;
                lineSegment.v[0] = vertex8 = Clip.interpolateNewVertex(vertex2, vertex, 3);
            }
        } else if (d3 < -1.0 || d4 < -1.0) {
            if (d4 < -1.0) {
                Vertex vertex9;
                lineSegment.v[1] = vertex9 = Clip.interpolateNewVertex(vertex, vertex2, 4);
            } else {
                Vertex vertex10;
                lineSegment.v[0] = vertex10 = Clip.interpolateNewVertex(vertex2, vertex, 4);
            }
        } else {
            System.err.println("Clipping error!");
            System.exit(-1);
        }
        return Clip.clip(lineSegment);
    }

    private static Vertex interpolateNewVertex(Vertex vertex, Vertex vertex2, int n) {
        double d = vertex.x;
        double d2 = vertex.y;
        double d3 = vertex2.x;
        double d4 = vertex2.y;
        double d5 = 0.0;
        if (1 == n) {
            d5 = (1.0 - d3) / (d - d3);
        } else if (2 == n) {
            d5 = (-1.0 - d3) / (d - d3);
        } else if (3 == n) {
            d5 = (1.0 - d4) / (d2 - d4);
        } else if (4 == n) {
            d5 = (-1.0 - d4) / (d2 - d4);
        }
        Vertex vertex3 = new Vertex();
        vertex3.x = (1.0 - d5) * d3 + d5 * d;
        vertex3.y = (1.0 - d5) * d4 + d5 * d2;
        vertex3.r = (1.0 - d5) * vertex2.r + d5 * vertex.r;
        vertex3.g = (1.0 - d5) * vertex2.g + d5 * vertex.g;
        vertex3.b = (1.0 - d5) * vertex2.b + d5 * vertex.b;
        return vertex3;
    }
}

