/*
 * Decompiled with CFR 0.152.
 */
package pipeline;

import framebuffer.FrameBuffer;
import pipeline.Clip;
import pipeline.Model2Camera;
import pipeline.PerspectiveDivision;
import pipeline.Project;
import pipeline.Rasterize;
import pipeline.RasterizeAntialias;
import pipeline.Viewport;
import scene.LineSegment;
import scene.Matrix;
import scene.Model;
import scene.Scene;

public class Pipeline {
    public static boolean doAntialiasing = false;
    public static boolean debug = false;
    public static boolean debug_visible = false;

    public static void render(Scene scene, FrameBuffer frameBuffer) {
        if (debug || debug_visible) {
            Pipeline.render_debug(scene, frameBuffer);
        } else {
            Pipeline.render_(scene, frameBuffer);
        }
    }

    private static void render_(Scene scene, FrameBuffer frameBuffer) {
        for (Model model : scene.modelList) {
            Pipeline.render_model(scene, model, new Matrix(1.0, 1.0, 1.0), frameBuffer);
        }
    }

    private static void render_model(Scene scene, Model model, Matrix matrix, FrameBuffer frameBuffer) {
        matrix = matrix.times(model.modelMatrix);
        for (LineSegment object : model.lineSegmentList) {
            LineSegment lineSegment = new LineSegment(object);
            Model2Camera.model2camera(lineSegment, matrix);
            Project.project(lineSegment, scene.camera.projMatrix);
            PerspectiveDivision.perspectiveDivide(lineSegment);
            if (!Clip.clip(lineSegment)) continue;
            Viewport.viewport(lineSegment, frameBuffer);
            if (doAntialiasing) {
                RasterizeAntialias.rasterize(lineSegment, frameBuffer);
                continue;
            }
            Rasterize.rasterize(lineSegment, frameBuffer);
        }
        for (Model model2 : model.nestedModels) {
            Pipeline.render_model(scene, model2, matrix, frameBuffer);
        }
    }

    private static void render_debug(Scene scene, FrameBuffer frameBuffer) {
        System.out.println("=== Render Scene ===================================");
        for (Model model : scene.modelList) {
            System.out.println("=== Render Model ===================================");
            Pipeline.render_model_debug(scene, model, new Matrix(1.0, 1.0, 1.0), frameBuffer);
            System.out.println("=== End Model ======================================");
        }
        System.out.println("=== End Scene ===================================");
    }

    private static void render_model_debug(Scene scene, Model model, Matrix matrix, FrameBuffer frameBuffer) {
        matrix = matrix.times(model.modelMatrix);
        for (LineSegment object : model.lineSegmentList) {
            StringBuilder stringBuilder = new StringBuilder();
            LineSegment lineSegment = new LineSegment(object);
            Pipeline.logLineSegment("0. Model", lineSegment, stringBuilder);
            Model2Camera.model2camera(lineSegment, matrix);
            Pipeline.logLineSegment("1. Camera", lineSegment, stringBuilder);
            Project.project(lineSegment, scene.camera.projMatrix);
            Pipeline.logLineSegment("2. Projected", lineSegment, stringBuilder);
            PerspectiveDivision.perspectiveDivide(lineSegment);
            Pipeline.logLineSegment("3. Divided", lineSegment, stringBuilder);
            if (Clip.clip(lineSegment)) {
                Pipeline.logLineSegment("4. Clipped", lineSegment, stringBuilder);
                Viewport.viewport(lineSegment, frameBuffer);
                Pipeline.logLineSegment("5. Viewport", lineSegment, stringBuilder);
                if (doAntialiasing) {
                    RasterizeAntialias.rasterize(lineSegment, frameBuffer);
                } else {
                    Rasterize.rasterize(lineSegment, frameBuffer);
                }
                if (debug_visible) {
                    System.out.println(stringBuilder);
                }
            }
            if (debug_visible) continue;
            System.out.println();
        }
        for (Model model2 : model.nestedModels) {
            System.out.println("====== Render Sub Model ========================");
            Pipeline.render_model_debug(scene, model2, matrix, frameBuffer);
            System.out.println("====== End Sub Model ===========================");
        }
    }

    private static void logLineSegment(String string, LineSegment lineSegment, StringBuilder stringBuilder) {
        if (debug_visible) {
            stringBuilder.append(string + " " + lineSegment.toString());
        } else {
            System.out.print(string + " " + lineSegment.toString());
        }
    }
}

