/*
 * Decompiled with CFR 0.152.
 */
package scene;

import scene.Vector;
import scene.Vertex;

public class Matrix {
    public Vector v1;
    public Vector v2;
    public Vector v3;
    public Vector v4;

    public Matrix() {
        this.v1 = new Vector();
        this.v2 = new Vector();
        this.v3 = new Vector();
        this.v4 = new Vector();
    }

    public Matrix(Vector vector) {
        this.v1 = new Vector(1.0, 0.0, 0.0, 0.0);
        this.v2 = new Vector(0.0, 1.0, 0.0, 0.0);
        this.v3 = new Vector(0.0, 0.0, 1.0, 0.0);
        this.v4 = new Vector(vector.x, vector.y, vector.z, 1.0);
    }

    public Matrix(double d) {
        this.v1 = new Vector(d, 0.0, 0.0, 0.0);
        this.v2 = new Vector(0.0, d, 0.0, 0.0);
        this.v3 = new Vector(0.0, 0.0, d, 0.0);
        this.v4 = new Vector(0.0, 0.0, 0.0, 1.0);
    }

    public Matrix(double d, double d2, double d3) {
        this.v1 = new Vector(d, 0.0, 0.0, 0.0);
        this.v2 = new Vector(0.0, d2, 0.0, 0.0);
        this.v3 = new Vector(0.0, 0.0, d3, 0.0);
        this.v4 = new Vector(0.0, 0.0, 0.0, 1.0);
    }

    public Matrix(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d6 = d2 / d5;
        double d7 = d3 / d5;
        double d8 = d4 / d5;
        double d9 = Math.cos(Math.PI / 180 * d);
        double d10 = Math.sin(Math.PI / 180 * d);
        this.v1 = new Vector(d6 * d6 * (1.0 - d9) + d9, d7 * d6 * (1.0 - d9) + d8 * d10, d8 * d6 * (1.0 - d9) - d7 * d10, 0.0);
        this.v2 = new Vector(d6 * d7 * (1.0 - d9) - d8 * d10, d7 * d7 * (1.0 - d9) + d9, d8 * d7 * (1.0 - d9) + d6 * d10, 0.0);
        this.v3 = new Vector(d6 * d8 * (1.0 - d9) + d7 * d10, d7 * d8 * (1.0 - d9) - d6 * d10, d8 * d8 * (1.0 - d9) + d9, 0.0);
        this.v4 = new Vector(0.0, 0.0, 0.0, 1.0);
    }

    public Matrix(Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this.v1 = vector;
        this.v2 = vector2;
        this.v3 = vector3;
        this.v4 = vector4;
    }

    public Matrix times(double d) {
        return new Matrix(this.v1.times(d), this.v2.times(d), this.v3.times(d), this.v4.times(d));
    }

    public Matrix times(Matrix matrix) {
        return new Matrix(this.times(matrix.v1), this.times(matrix.v2), this.times(matrix.v3), this.times(matrix.v4));
    }

    public Vector times(Vector vector) {
        return this.v1.times(vector.x).plus(this.v2.times(vector.y).plus(this.v3.times(vector.z).plus(this.v4.times(vector.w))));
    }

    public Vertex times(Vertex vertex) {
        Vector vector = this.v1.times(vertex.x).plus(this.v2.times(vertex.y).plus(this.v3.times(vertex.z).plus(this.v4.times(vertex.w))));
        Vertex vertex2 = new Vertex(vector.x, vector.y, vector.z, vector.w);
        vertex2.setColor(vertex);
        return vertex2;
    }

    public String toString() {
        String string = "";
        int n = 5;
        int n2 = n + 4;
        String string2 = "% " + n2 + "." + n + "f  % " + n2 + "." + n + "f  % " + n2 + "." + n + "f  % " + n2 + "." + n + "f";
        string = string + String.format("[[" + string2 + " ]\n", this.v1.x, this.v2.x, this.v3.x, this.v4.x);
        string = string + String.format(" [" + string2 + " ]\n", this.v1.y, this.v2.y, this.v3.y, this.v4.y);
        string = string + String.format(" [" + string2 + " ]\n", this.v1.z, this.v2.z, this.v3.z, this.v4.z);
        string = string + String.format(" [" + string2 + " ]]\n", this.v1.w, this.v2.w, this.v3.w, this.v4.w);
        return string;
    }
}

