/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import scene.LineSegment;
import scene.Matrix;
import scene.Vector;

public class Model {
    public Matrix modelMatrix;
    public List<LineSegment> lineSegmentList = new LinkedList<LineSegment>();
    public List<Model> nestedModels = new LinkedList<Model>();

    public Model() {
        this.modelMatrix = new Matrix(1.0);
    }

    public void addLineSegment(LineSegment ... lineSegmentArray) {
        for (LineSegment lineSegment : lineSegmentArray) {
            this.lineSegmentList.add(lineSegment);
        }
    }

    public void addSubModel(Model ... modelArray) {
        for (Model model : modelArray) {
            this.nestedModels.add(model);
        }
    }

    public int indexOfSubModel(Model model) {
        return this.nestedModels.indexOf(model);
    }

    public Model getSubModel(int n) {
        return this.nestedModels.get(n);
    }

    public Model setSubModel(int n, Model model) {
        return this.nestedModels.set(n, model);
    }

    public void model2Identity() {
        this.modelMatrix = new Matrix(1.0);
    }

    public void modelMult(Matrix matrix) {
        this.modelMatrix = this.modelMatrix.times(matrix);
    }

    public void modelRotate(double d, double d2, double d3, double d4) {
        this.modelMult(new Matrix(d, d2, d3, d4));
    }

    public void modelScale(double d, double d2, double d3) {
        this.modelMult(new Matrix(d, d2, d3));
    }

    public void modelTranslate(double d, double d2, double d3) {
        this.modelMult(new Matrix(new Vector(d, d2, d3)));
    }

    public void setColor(Color color) {
        for (LineSegment lineSegment : this.lineSegmentList) {
            lineSegment.setColor(color);
        }
    }

    public void setColorRandom() {
        this.lineSegmentList.get(0).setColorRandom();
        Color color = this.lineSegmentList.get((int)0).v[0].getColor();
        for (LineSegment lineSegment : this.lineSegmentList) {
            lineSegment.setColor(color);
        }
    }

    public void setRandomColors() {
        for (LineSegment lineSegment : this.lineSegmentList) {
            lineSegment.setColorRandom();
        }
    }

    public String toString() {
        String string = "";
        string = string + "The Model matrix is\n";
        string = string + this.modelMatrix;
        string = string + "This Model has " + this.lineSegmentList.size() + " line segments\n";
        for (LineSegment lineSegment : this.lineSegmentList) {
            string = string + lineSegment.toString();
        }
        return string;
    }
}

