/*
 * Decompiled with CFR 0.152.
 */
package scene;

public class Vector {
    public double x;
    public double y;
    public double z;
    public double w;

    public Vector() {
        this.set(0.0, 0.0, 0.0);
    }

    public Vector(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public Vector(Vector vector) {
        this.set(vector.x, vector.y, vector.z, vector.w);
    }

    public Vector(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public void set(double d, double d2, double d3) {
        this.set(d, d2, d3, 0.0);
    }

    public void set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public Vector times(double d) {
        return new Vector(d * this.x, d * this.y, d * this.z, d * this.w);
    }

    public Vector plus(Vector vector) {
        return new Vector(this.x + vector.x, this.y + vector.y, this.z + vector.z, this.w + vector.w);
    }

    public Vector minus(Vector vector) {
        return new Vector(this.x - vector.x, this.y - vector.y, this.z - vector.z, this.w - vector.w);
    }

    public Vector crossProduct(Vector vector) {
        return new Vector(this.y * vector.z - this.z * vector.y, this.z * vector.x - this.x * vector.z, this.x * vector.y - this.y * vector.x);
    }

    public double dotProduct(Vector vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public Vector normalize() {
        double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        return new Vector(this.x / d, this.y / d, this.z / d);
    }

    public String toString() {
        int n = 5;
        int n2 = n + 4;
        String string = "[x,y,z,w] = [% " + n2 + "." + n + "f  % " + n2 + "." + n + "f  % " + n2 + "." + n + "f  % " + n2 + "." + n + "f]\n";
        return String.format(string, this.x, this.y, this.z, this.w);
    }
}

