/*
 * Decompiled with CFR 0.152.
 */
package scene;

import java.awt.Color;
import java.util.Random;
import scene.Matrix;
import scene.Vector;

public class Vertex {
    public double x;
    public double y;
    public double z;
    public double w;
    public double r = 1.0;
    public double g = 1.0;
    public double b = 1.0;

    public Vertex() {
        this.set(0.0, 0.0, 0.0, 1.0);
    }

    public Vertex(double d, double d2, double d3) {
        this.set(d, d2, d3, 1.0);
    }

    public Vertex(double d, double d2, double d3, double d4) {
        this.set(d, d2, d3, d4);
    }

    public Vertex(double d, double d2, double d3, Color color) {
        this.set(d, d2, d3, 1.0);
        this.setColor(color);
    }

    public Vertex(double d, double d2, double d3, double d4, Color color) {
        this.set(d, d2, d3, d4);
        this.setColor(color);
    }

    public Vertex(Vertex vertex) {
        this.set(vertex.x, vertex.y, vertex.z, vertex.w);
        this.setColor(vertex);
    }

    public void set(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public void times(Matrix matrix) {
        Vector vector = matrix.v1;
        Vector vector2 = matrix.v2;
        Vector vector3 = matrix.v3;
        Vector vector4 = matrix.v4;
        double d = vector.x * this.x + vector2.x * this.y + vector3.x * this.z + vector4.x * this.w;
        double d2 = vector.y * this.x + vector2.y * this.y + vector3.y * this.z + vector4.y * this.w;
        double d3 = vector.z * this.x + vector2.z * this.y + vector3.z * this.z + vector4.z * this.w;
        double d4 = vector.w * this.x + vector2.w * this.y + vector3.w * this.z + vector4.w * this.w;
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.w = d4;
    }

    public void perspectiveDivision() {
        double d = 1.0 / this.w;
        this.x *= d;
        this.y *= d;
        this.z *= d;
        this.w *= 1.0;
    }

    public Color getColor() {
        return new Color((float)this.r, (float)this.g, (float)this.b);
    }

    public void setColor(double d, double d2, double d3) {
        this.r = d;
        this.g = d2;
        this.b = d3;
        if (d < 0.0 || d > 1.0 || d2 < 0.0 || d2 > 1.0 || d3 < 0.0 || d3 > 1.0) {
            System.err.println("ERROR! Invalid double color for vertex");
            System.err.println(this.toString());
            System.err.printf("<r,g,b> = <% .5f  % .5f  % .5f>\n", d, d2, d3);
            System.exit(-1);
        }
    }

    public void setColor(int n, int n2, int n3) {
        this.r = (float)n / 255.0f;
        this.g = (float)n2 / 255.0f;
        this.b = (float)n3 / 255.0f;
        if (n < 0 || n > 255 || n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255) {
            System.err.println("ERROR! Invalid int color for vertex");
            System.err.println(this.toString());
            System.err.printf("<r,g,b> = <%d  %d  %d>\n", n, n2, n3);
            System.exit(-1);
        }
    }

    public void setColor(Color color) {
        this.setColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public void setColor(Vertex vertex) {
        this.setColor(vertex.r, vertex.g, vertex.b);
    }

    public void setColorRandom() {
        Random random = new Random();
        double d = random.nextDouble();
        double d2 = random.nextDouble();
        double d3 = random.nextDouble();
        this.setColor(d, d2, d3);
    }

    public String toString() {
        int n = 5;
        int n2 = n + 4;
        String string = "(x,y,z,w) = (% " + n2 + "." + n + "f  % " + n2 + "." + n + "f  % " + n2 + "." + n + "f  % " + n2 + "." + n + "f)\n";
        return String.format(string, this.x, this.y, this.z, this.w);
    }
}

