/*
 * Decompiled with CFR 0.152.
 */
package scene.models;

import scene.LineSegment;
import scene.Model;
import scene.Vertex;

public class FrustumCircularModel
extends Model {
    public FrustumCircularModel() {
        this(3, 1, 0.5, 1.0, 1.0);
    }

    public FrustumCircularModel(int n, int n2, double d, double d2, double d3) {
        LineSegment lineSegment;
        int n3;
        Vertex[][] vertexArray = new Vertex[n2 + 2][n];
        for (int i = 0; i < n; ++i) {
            double d4 = Math.cos((double)i * (Math.PI * 2) / (double)n);
            double d5 = Math.sin((double)i * (Math.PI * 2) / (double)n);
            for (int j = 0; j <= n2 + 1; ++j) {
                double d6 = (double)j / (double)(n2 + 1) * d + (double)(n2 + 1 - j) / (double)(n2 + 1) * d2;
                vertexArray[j][i] = new Vertex(d6 * d4, d3 - (double)j * d3 / (double)(n2 + 1), d6 * d5);
            }
        }
        Vertex vertex = new Vertex(0.0, d3, 0.0);
        Vertex vertex2 = new Vertex(0.0, 0.0, 0.0);
        for (n3 = 0; n3 <= n2 + 1; ++n3) {
            for (int i = 0; i < n - 1; ++i) {
                lineSegment = new LineSegment(new Vertex(vertexArray[n3][i]), new Vertex(vertexArray[n3][i + 1]));
                this.addLineSegment(lineSegment);
            }
            lineSegment = new LineSegment(new Vertex(vertexArray[n3][n - 1]), new Vertex(vertexArray[n3][0]));
            this.addLineSegment(lineSegment);
        }
        for (n3 = 0; n3 < n; ++n3) {
            lineSegment = new LineSegment(new Vertex(vertex), new Vertex(vertexArray[0][n3]));
            this.addLineSegment(lineSegment);
            lineSegment = new LineSegment(new Vertex(vertexArray[0][n3]), new Vertex(vertexArray[n2 + 1][n3]));
            this.addLineSegment(lineSegment);
            lineSegment = new LineSegment(new Vertex(vertexArray[n2 + 1][n3]), new Vertex(vertex2));
            this.addLineSegment(lineSegment);
        }
    }
}

