/*
 * Decompiled with CFR 0.152.
 */
package scene.models;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import scene.LineSegment;
import scene.Model;
import scene.Vertex;

public class GRSModel
extends Model {
    public double left = 0.0;
    public double top = 0.0;
    public double right = 0.0;
    public double bottom = 0.0;
    public int numLineStrips = 0;

    public GRSModel(File file) {
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            string = file.getCanonicalPath();
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace(System.err);
            System.err.printf("ERROR! Could not find GRS file: %s\n", string);
            System.exit(-1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.err.printf("ERROR! Could not open GRS file: %s\n", string);
            System.exit(-1);
        }
        Scanner scanner = new Scanner(fileInputStream);
        try {
            String string2 = scanner.nextLine();
            while (!string2.startsWith("*")) {
                string2 = scanner.nextLine();
            }
            this.left = scanner.nextDouble();
            this.top = scanner.nextDouble();
            this.right = scanner.nextDouble();
            this.bottom = scanner.nextDouble();
            this.numLineStrips = scanner.nextInt();
            for (int i = 0; i < this.numLineStrips; ++i) {
                int n = scanner.nextInt();
                double d = scanner.nextDouble();
                double d2 = scanner.nextDouble();
                Vertex vertex = new Vertex(d, d2, 0.0);
                for (int j = 1; j < n; ++j) {
                    d = scanner.nextDouble();
                    d2 = scanner.nextDouble();
                    Vertex vertex2 = new Vertex(d, d2, 0.0);
                    this.addLineSegment(new LineSegment(vertex, vertex2));
                    vertex = new Vertex(vertex2);
                }
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.err.printf("ERROR! Could not read GRS file: %s\n", string);
            System.exit(-1);
        }
    }
}

