/*
 * Decompiled with CFR 0.152.
 */
package scene.models;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scene.LineSegment;
import scene.Model;
import scene.Vertex;

public class ObjSimpleModel
extends Model {
    public ObjSimpleModel(File file) {
        String string = null;
        FileInputStream fileInputStream = null;
        try {
            string = file.getCanonicalPath();
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace(System.err);
            System.err.printf("ERROR! Could not find OBJ file: %s\n", string);
            System.exit(-1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.err.printf("ERROR! Could not open OBJ file: %s\n", string);
            System.exit(-1);
        }
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        try {
            Pattern pattern = Pattern.compile("^(\\d*)[/]?(\\d*)[/]?(\\d*)");
            Scanner scanner = new Scanner(fileInputStream);
            while (scanner.hasNext()) {
                String string2;
                Object object;
                Object object2;
                String string3 = scanner.next();
                if (string3.startsWith("#") || string3.startsWith("vt") || string3.startsWith("vn") || string3.startsWith("s") || string3.startsWith("g") || string3.startsWith("o") || string3.startsWith("usemtl") || string3.startsWith("mtllib")) {
                    scanner.nextLine();
                    continue;
                }
                if (string3.startsWith("v")) {
                    double d = scanner.nextDouble();
                    double d2 = scanner.nextDouble();
                    double d3 = scanner.nextDouble();
                    object2 = new Vertex(d, d2, d3);
                    arrayList.add((Vertex)object2);
                    continue;
                }
                if (!string3.startsWith("f")) continue;
                String string4 = scanner.nextLine();
                Scanner scanner2 = new Scanner(string4);
                int[] nArray = new int[3];
                for (int i = 0; i < 3; ++i) {
                    object = scanner2.next();
                    object2 = pattern.matcher((CharSequence)object);
                    if (((Matcher)object2).find()) {
                        nArray[i] = Integer.parseInt(((Matcher)object2).group(1));
                        string2 = ((Matcher)object2).group(2);
                        String string5 = ((Matcher)object2).group(3);
                        continue;
                    }
                    System.err.println("Error: bad face: " + (String)object);
                }
                LineSegment lineSegment = new LineSegment(new Vertex((Vertex)arrayList.get(nArray[0] - 1)), new Vertex((Vertex)arrayList.get(nArray[1] - 1)));
                this.addLineSegment(lineSegment);
                lineSegment = new LineSegment(new Vertex((Vertex)arrayList.get(nArray[1] - 1)), new Vertex((Vertex)arrayList.get(nArray[2] - 1)));
                this.addLineSegment(lineSegment);
                while (scanner2.hasNext()) {
                    nArray[1] = nArray[2];
                    String string6 = scanner2.next();
                    object = pattern.matcher(string6);
                    if (((Matcher)object).find()) {
                        nArray[2] = Integer.parseInt(((Matcher)object).group(1));
                        object2 = ((Matcher)object).group(2);
                        string2 = ((Matcher)object).group(3);
                    } else {
                        System.err.println("Error: bad face: " + string6);
                    }
                    lineSegment = new LineSegment(new Vertex((Vertex)arrayList.get(nArray[1] - 1)), new Vertex((Vertex)arrayList.get(nArray[2] - 1)));
                    this.addLineSegment(lineSegment);
                }
                lineSegment = new LineSegment(new Vertex((Vertex)arrayList.get(nArray[2] - 1)), new Vertex((Vertex)arrayList.get(nArray[0] - 1)));
                this.addLineSegment(lineSegment);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.err.printf("ERROR! Could not read OBJ file: %s\n", string);
            System.exit(-1);
        }
    }
}

