/*
 * Decompiled with CFR 0.152.
 */
package scene.models;

import scene.LineSegment;
import scene.Model;
import scene.Vertex;

public class PrismModel
extends Model {
    public PrismModel() {
        this(0, 1.0, (float)(Math.sqrt(2.0) / Math.sqrt(3.0)));
    }

    public PrismModel(double d) {
        this(0, d, (float)(Math.sqrt(2.0) / Math.sqrt(3.0)));
    }

    public PrismModel(int n, double d) {
        this(n, d, (float)(Math.sqrt(2.0) / Math.sqrt(3.0)));
    }

    public PrismModel(int n, double d, double d2) {
        this(n, d, (float)(Math.tan(d2) / (2.0 * Math.sqrt(3.0))));
    }

    private PrismModel(int n, double d, float f) {
        double d2 = Math.sqrt(3.0);
        double d3 = Math.sqrt(2.0);
        Vertex[] vertexArray = new Vertex[]{new Vertex(1.0 / d2, d, 0.0), new Vertex(-0.5 / d2, d, 0.5), new Vertex(-0.5 / d2, d, -0.5), new Vertex(1.0 / d2, -d, 0.0), new Vertex(-0.5 / d2, -d, 0.5), new Vertex(-0.5 / d2, -d, -0.5), new Vertex(0.0, d + (double)f, 0.0), new Vertex(0.0, -d - (double)f, 0.0)};
        LineSegment[] lineSegmentArray = new LineSegment[15];
        int n2 = 0;
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[6]), new Vertex(vertexArray[0]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[6]), new Vertex(vertexArray[1]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[6]), new Vertex(vertexArray[2]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[0]), new Vertex(vertexArray[1]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[1]), new Vertex(vertexArray[2]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[2]), new Vertex(vertexArray[0]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[0]), new Vertex(vertexArray[3]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[1]), new Vertex(vertexArray[4]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[2]), new Vertex(vertexArray[5]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[3]), new Vertex(vertexArray[4]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[4]), new Vertex(vertexArray[5]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[5]), new Vertex(vertexArray[3]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[7]), new Vertex(vertexArray[3]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[7]), new Vertex(vertexArray[4]));
        lineSegmentArray[n2++] = new LineSegment(new Vertex(vertexArray[7]), new Vertex(vertexArray[5]));
        for (n2 = 0; n2 < lineSegmentArray.length; ++n2) {
            this.addLineSegment(lineSegmentArray[n2]);
        }
        if (n > 0) {
            Vertex[][] vertexArray2 = new Vertex[n][3];
            double d4 = 2.0 * d / (double)(n + 1);
            for (int i = 0; i < n; ++i) {
                double d5 = -d + (double)(i + 1) * d4;
                vertexArray2[i][0] = new Vertex(1.0 / d2, d5, 0.0);
                vertexArray2[i][1] = new Vertex(-0.5 / d2, d5, 0.5);
                vertexArray2[i][2] = new Vertex(-0.5 / d2, d5, -0.5);
                this.addLineSegment(new LineSegment(new Vertex(vertexArray2[i][0]), new Vertex(vertexArray2[i][1])));
                this.addLineSegment(new LineSegment(new Vertex(vertexArray2[i][1]), new Vertex(vertexArray2[i][2])));
                this.addLineSegment(new LineSegment(new Vertex(vertexArray2[i][2]), new Vertex(vertexArray2[i][0])));
            }
        }
    }
}

