/*
 * Decompiled with CFR 0.152.
 */
package scene.models;

import scene.LineSegment;
import scene.Model;
import scene.Vertex;

public class TorusModel
extends Model {
    public TorusModel() {
        this(6, 6, 0.75, 0.25);
    }

    public TorusModel(int n, int n2, double d, double d2) {
        int n3;
        int n4;
        Vertex[][] vertexArray = new Vertex[n2][n];
        for (int i = 0; i < n; ++i) {
            double d3 = Math.cos((double)i * (Math.PI * 2) / (double)n);
            double d4 = Math.sin((double)i * (Math.PI * 2) / (double)n);
            for (int j = 0; j < n2; ++j) {
                double d5 = Math.cos((double)j * (Math.PI * 2) / (double)n2);
                double d6 = Math.sin((double)j * (Math.PI * 2) / (double)n2);
                vertexArray[j][i] = new Vertex((d + d2 * d5) * d3, d2 * d6, (d + d2 * d5) * d4);
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                LineSegment lineSegment = new LineSegment(new Vertex(vertexArray[n3][n4]), new Vertex(vertexArray[n3 + 1][n4]));
                this.addLineSegment(lineSegment);
            }
            LineSegment lineSegment = new LineSegment(new Vertex(vertexArray[n2 - 1][n4]), new Vertex(vertexArray[0][n4]));
            this.addLineSegment(lineSegment);
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n - 1; ++n3) {
                LineSegment lineSegment = new LineSegment(new Vertex(vertexArray[n4][n3]), new Vertex(vertexArray[n4][n3 + 1]));
                this.addLineSegment(lineSegment);
            }
            LineSegment lineSegment = new LineSegment(new Vertex(vertexArray[n4][n - 1]), new Vertex(vertexArray[n4][0]));
            this.addLineSegment(lineSegment);
        }
    }
}

