/*

*/
import scene.*;
import scene.models.*;
import pipeline.*;
import framebuffer.*;

import java.awt.Color;
import java.io.File;

/**
   Compare with
      http://threejs.org/examples/#webgl_geometries
*/
public class Geometries_nested_v1
{
   public static void main(String[] args)
   {
      // Creat an array of models
      Model[] models = new Model[15];

      int j = -1;

      // row 1
      j++;
      models[j] = new Model();
      models[j].addSubModel(new ObjSimpleModel(new File("assets\\great_rhombicosidodecahedron.obj")));
      models[j].modelTranslate(-4, 0, -4);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setColor(Color.red);

      j++;
      models[j] = new Model();
      models[j].addSubModel(new Model());
      models[j].getSubModel(0).addSubModel(new FrustumCircularModel(10, 10, 0.5, 1, 1));
      models[j].getSubModel(0).getSubModel(0).modelTranslate(0, -0.5, 0);
      models[j].modelTranslate(-4, 0, -2);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).getSubModel(0).setColor(Color.orange);

      j++;
      models[j] = new Model();
      models[j].addSubModel(new Model());
      models[j].getSubModel(0).addSubModel(new CubeModel(1, 1, 1));
      models[j].getSubModel(0).getSubModel(0).modelTranslate(-0.5, -0.5, -0.5);
      models[j].modelTranslate(-4, 0, 0);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).getSubModel(0).setColor(Color.lightGray);

      j++;
      models[j] = new Model();
      models[j].addSubModel(new Axes3DModel(1, 1, 1, Color.red, Color.green, Color.blue));
      models[j].modelTranslate(-4, 0, 2);
      models[j].modelScale(1.0, 1.0, 1.0);
      //models[j].getSubModel(0).setColor(Color.blue);

      j++;
      models[j] = new Model();
      models[j].addSubModel(new SphereModel(30, 30, 1));
      models[j].modelTranslate(-4, 0, 4);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setColor(Color.lightGray);

      // row 2
      j++;
      models[j] = new Model();
      models[j].addSubModel(new CylinderModel(30, 30, 0.5, 1));
      models[j].modelTranslate(0, 0, -4);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setColor(Color.blue.brighter().brighter());

      j++;
      models[j] = new Model();
      models[j].addSubModel(new ObjSimpleModel(new File("assets\\horse.obj")));
      models[j].modelTranslate(0, 0, -2);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setColor(Color.pink);

      j++;
      models[j] = new Model();
      models[j].addSubModel(new GRSModel(new File("assets\\grs\\vinci.grs")));
      models[j].modelTranslate(0, 0, 0);
      models[j].modelScale(1.5, 1.5, 1.5);
      models[j].getSubModel(0).setColor(Color.blue);

      j++;
      models[j] = new Model();
      models[j].addSubModel(new TetrahedronModel());
      models[j].modelTranslate(0, 0, 2);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setColor(Color.cyan);

      j++;
      models[j] = new Model();
      models[j].addSubModel(new ObjSimpleModel(new File("assets\\small_rhombicosidodecahedron.obj")));
      models[j].modelTranslate(0, 0, 4);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setColor(Color.magenta);

      // row 3
      j++;
      models[j] = new Model();
      models[j].addSubModel(new PrismModel(10, 1));
      models[j].modelTranslate(4, 0, -4);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setColor(Color.green.darker().darker());

      j++;
      models[j] = new Model();
      models[j].addSubModel(new GRSModel(new File("assets\\grs\\bronto.grs")));
      models[j].modelTranslate(4, 0, -2);
      models[j].modelScale(2.0, 2.0, 2.0);
      models[j].getSubModel(0).setColor(Color.red);

      j++;
      models[j] = new Model();
      models[j].addSubModel( new TorusModel(30, 30, 0.75, 0.25));
      models[j].modelTranslate(4, 0, 0);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setRandomColors();

      j++;
      models[j] = new Model();
      models[j].addSubModel( new OctahedronModel() );
      models[j].modelTranslate(4, 0, 2);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).setColor(Color.blue);

      j++;
      models[j] = new Model();
      models[j].addSubModel(new Model());
      models[j].getSubModel(0).addSubModel(new ConeModel(30, 30, 0.5, 1));
      models[j].getSubModel(0).getSubModel(0).modelTranslate(0, -0.5, 0);
      models[j].modelTranslate(4, 0, 4);
      models[j].modelScale(1.0, 1.0, 1.0);
      models[j].getSubModel(0).getSubModel(0).setColor(Color.yellow);

      int numberOfModels = j + 1;

      // Create a horizontal plane
      Model xzPlane = new PanelModel(-6, 6, -7, 7);
      xzPlane.setColor(Color.darkGray);
      // x, y and z axes
      Model xyzAxes = new Axes3DModel(6, -6, 6, 0, 7, -7,  Color.red);

      // Create a "top level" model.
      Model topLevel = new Model();
      // Add all the other models as submodels of the top level model
      for (int i = 0; i < numberOfModels; i++)
      {
         topLevel.addSubModel(models[i]);
      }
      topLevel.addSubModel(xzPlane);
      topLevel.addSubModel(xyzAxes);


      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the top level model to the Scene.
      scene.addModel(topLevel);


      // Create a Camera object.
      Camera camera = new Camera();

      // Add the Camera to the Scene.
      scene.setCamera(camera);


      // Create a framebuffer to render our scene into.
      int vp_width  = 1200;
      int vp_height = 600;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.black);

      long startTime, stopTime;
      startTime = System.currentTimeMillis();
      for (int i = 0; i <= 360; i++)
      {
         topLevel.model2Identity();
         // Push the model away from the camera
         topLevel.modelTranslate(0.5, -3, -10.5);
         // rotate the top level model on its axis
         topLevel.modelRotate(i, 0,1,0);

         // rotate each of the sub models on its own axis
         for (int k = 0; k < numberOfModels; k++)
         {
            models[k].getSubModel(0).modelRotate(2, 1,0,0);
            models[k].getSubModel(0).modelRotate(2, 0,1,0);
         }

         // Render
       //Renderer.doAntialiasing = true;
         fb.clearFB(java.awt.Color.black);
         Pipeline.render(scene, fb);
         fb.dumpFB2File(String.format("PPM_Geometries_nested_v1_Frame%03d.ppm", i));
      }
      stopTime = System.currentTimeMillis();
      System.out.println("Wall-clock time: " + (stopTime - startTime));
   }
}