/*

*/
import scene.*;
import scene.models.*;
import pipeline.*;
import framebuffer.*;

import java.awt.Color;
import java.io.File;

/**
   Compare with
      http://threejs.org/examples/#webgl_geometries
*/
public class Geometries_v1
{
   public static void main(String[] args)
   {
      // Create a two-dimensional array of models
      Model[][] models = new Model[3][5];

      // row 0
      models[0][0] = new ObjSimpleModel(new File("assets\\great_rhombicosidodecahedron.obj"));
      models[0][0].setColor(Color.red);

      models[0][1] = new FrustumCircularModel(10, 10, 0.5, 1, 1);
      models[0][1].setColor(Color.orange);

      models[0][2] = new CubeModel(1, 1, 1);
      models[0][2].setColor(Color.lightGray);

      models[0][3] = new Axes3DModel(1, 1, 1, Color.red, Color.green, Color.blue);

      models[0][4] = new SphereModel(30, 30, 1);
      models[0][4].setColor(Color.lightGray);

      // row 1
      models[1][0] = new CylinderModel(30, 30, 0.5, 1);
      models[1][0].setColor(Color.blue.brighter().brighter());

      models[1][1] = new ObjSimpleModel(new File("assets\\horse.obj"));
      models[1][1].setColor(Color.pink);

      models[1][2] = new GRSModel(new File("assets\\grs\\vinci.grs"));
      models[1][2].setColor(Color.blue);

      models[1][3] = new TetrahedronModel();
      models[1][3].setColor(Color.cyan);

      models[1][4] = new ObjSimpleModel(new File("assets\\small_rhombicosidodecahedron.obj"));
      models[1][4].setColor(Color.magenta);

      // row 2
      models[2][0] = new PrismModel(10, 1);
      models[2][0].setColor(Color.green.darker().darker());

      models[2][1] = new GRSModel(new File("assets\\grs\\bronto.grs"));
      models[2][1].setColor(Color.red);

      models[2][2] = new TorusModel(30, 30, 0.75, 0.25);
      models[2][2].setRandomColors();

      models[2][3] = new OctahedronModel();
      models[2][3].setColor(Color.blue);

      models[2][4] = new ConeModel(30, 30, 0.5, 1);
      models[2][4].setColor(Color.yellow);


      // Create a horizontal coordinate plane model.
      Model xzPlane = new PanelModel(-6, 6, -7, 7);
      xzPlane.setColor(Color.darkGray);
      // x, y and z axes
      Vertex x1 = new Vertex(-6, 0, 0);
      Vertex x2 = new Vertex( 6, 0, 0);
      x1.setColor(Color.red);
      x2.setColor(Color.red);
      Vertex y1 = new Vertex(0, 0, 0);
      Vertex y2 = new Vertex(0, 6, 0);
      y1.setColor(Color.red);
      y2.setColor(Color.red);
      Vertex z1 = new Vertex(0, 0, -7);
      Vertex z2 = new Vertex(0, 0,  7);
      z1.setColor(Color.red);
      z2.setColor(Color.red);
      xzPlane.addLineSegment( new LineSegment(x1, x2) );
      xzPlane.addLineSegment( new LineSegment(y1, y2) );
      xzPlane.addLineSegment( new LineSegment(z1, z2) );
      // Push the plane away from the camera
      xzPlane.modelTranslate(0.5, -3, -10.5);


      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the models to the Scene.
      for (int i = 0; i < models.length; i++)
         for (int j = 0; j < models[i].length; j++)
         {
            scene.addModel(models[i][j]);
         }
      scene.addModel(xzPlane);


      // Create a Camera object.
      Camera camera = new Camera();

      // Add the Camera to the Scene.
      scene.setCamera(camera);


      // Create a framebuffer to render our scene into.
      int vp_width  = 1200;
      int vp_height = 600;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);
      // Give the framebuffer a nice background color.
      fb.clearFB(java.awt.Color.black);

      long startTime, stopTime;
      startTime = System.currentTimeMillis();
      for (int k = 0; k < 360; k++)
      {
         // rotate each of the models on its own axis
         for (int i = 0; i < models.length; i++)
            for (int j = 0; j < models[i].length; j++)
            {
               models[i][j].model2Identity();
               // Push the model away from the camera
               models[i][j].modelTranslate(0.5, -3, -10.5);
               // now rotate
               models[i][j].modelTranslate(4-4*i, 0, 6-3*j);
               models[i][j].modelRotate(3*k, 1,0,0);
               models[i][j].modelRotate(3*k, 0,1,0);
            }

         // Render
       //Renderer.doAntialiasing = true;
         fb.clearFB(java.awt.Color.black);
         Pipeline.render(scene, fb);
         fb.dumpFB2File(String.format("PPM_Geometries_v1_Frame%03d.ppm", k));
      }
      stopTime = System.currentTimeMillis();
      System.out.println("Wall-clock time: " + (stopTime - startTime));
   }
}
