/*

*/
import scene.*;
import scene.models.*;
import pipeline.*;
import framebuffer.*;

import java.io.File;
import java.awt.Color;
import java.awt.event.*;
import java.util.ArrayList;

/**

*/
public class InteractiveModels_v7
{
   private static int perspProjMatrix1Index = 0;

   private static double xTranslation = 0.0;
   private static double yTranslation = 0.0;
   private static double zTranslation = 0.0;
   private static double xRotation = 0.0;
   private static double yRotation = 0.0;
   private static double zRotation = 0.0;
   private static double scale = 1.0;

   private static ArrayList<Model> modelArray = new ArrayList<Model>();

   public static void main(String[] args)
   {
      System.out.println("Use the 'd' key to toggle debugging information on and off.");
      System.out.println("Use the digit keys '0' - '9' to choose a model.");
      System.out.println("Use the 'p' key to toggle between parallel and orthographic projection.");
      System.out.println("Use the x/X, y/Y, z/Z, keys to translate the model along the x, y, z axes.");
      System.out.println("Use the u/U, v/V, w/W, keys to rotate the model around the x, y, z axes.");
      System.out.println("Use the s/S keys to scale the size of the model.");
      System.out.println("Use the 'c' key to change the solid model colors.");
      System.out.println("Use the 'e' key to change the random edge colors.");
      System.out.println("Use the 'a' key to toggle antialiasing on and off.");
      System.out.println("Use the '/' key to cycle through the perspective projection matrices.");

      // Create several Model objects.
      modelArray.add( new ObjSimpleModel(new File("assets/apple.obj")) );
      modelArray.add( new ObjSimpleModel(new File("assets/cow.obj")) );
      modelArray.add( new ObjSimpleModel(new File("assets/galleon.obj")) );
      modelArray.add( new ObjSimpleModel(new File("assets/teapot.obj")) );
//      modelArray.add( new ObjSimpleModel(new File("assets/cessna.obj")) );
//      modelArray.add( new ObjSimpleModel(new File("assets/horse.obj")) );
//      modelArray.add( new SphereModel(30, 30, 1) );
      modelArray.add( new CylinderModel(20, 20, 0.5, 1) );
      modelArray.add( new TorusModel(25, 25, 0.75, 0.25) );
      modelArray.add( new ObjSimpleModel(new File("assets/small_rhombicosidodecahedron.obj")) );
      modelArray.add( new ObjSimpleModel(new File("assets/great_rhombicosidodecahedron.obj")) );
      modelArray.add( new ObjSimpleModel(new File("assets/cessna.obj")) );

      // Push the models away from where the camera is.
      for (Model m : modelArray)
      {
         m.modelTranslate(0, 0, -2);
      }

      // Push the last model off to the side.
      modelArray.get(modelArray.size() - 1).modelTranslate(3, 0, 0);

      // Give the models random colors.
      for (Model m : modelArray)
      {
         m.setColorRandom();
      }


      // Create the Scene object that we shall render.
      final Scene scene = new Scene();

      // Add three models to the Scene.
      scene.addModel( modelArray.get(1),
                      modelArray.get(modelArray.size() - 2),
                      modelArray.get(modelArray.size() - 1) );


      // Create a Camera object.
      Camera camera = new Camera();

      // Add the Camera to the Scene.
      scene.setCamera(camera);


      // Create a InteractiveFrame and a FrameBuffer to render our scene into.
      int width  = 512;
      int height = 512;

      @SuppressWarnings("serial")
      final InteractiveFrame app = new InteractiveFrame("Renderer 7", width, height)
      {
         // Implement part of the KeyListener interface.
         @Override public void keyTyped(KeyEvent e)
         {
            //System.out.println( e );
            char c = e.getKeyChar();
            if ('d' == c)
            {
             //Pipeline.debug = ! Pipeline.debug;
               Pipeline.debug_visible = ! Pipeline.debug_visible;
             //Rasterize.debug = ! Rasterize.debug;
             //RasterizeAntialias.debug = ! RasterizeAntialias.debug;
            }
            else if ('/' == c)
            {
               perspProjMatrix1Index = (perspProjMatrix1Index + 1) % 3;
            }
            else if ( Character.isDigit(c) )
            {
               int n = Integer.parseInt( Character.toString(c) );
               if (n < modelArray.size() - 2)
               {
                  scene.modelList.set(0, modelArray.get(n));
               }
            }
            else if ('a' == c)
            {
               Pipeline.doAntialiasing = ! Pipeline.doAntialiasing;
            }
            else if ('c' == c)
            {
               // Change the solid random color of each model.
               for (Model m : scene.modelList)
                     m.setColorRandom();
            }
            else if ('e' == c)
            {
               // Change the random color at each edge.
               for (Model m : scene.modelList)
                  for (LineSegment ls : m.lineSegmentList)
                     ls.setColorRandom();
            }
            else if ('p' == c)
            {
               if (scene.camera.perspective)
               {
                  scene.camera.projOrtho();
               }
               else
               {
                  scene.camera.projPerspective();
               }
            }
            else if ('s' == c) // Scale the model 10% smaller.
            {
               scale *= 0.9;
            }
            else if ('S' == c) // Scale the model 10% larger.
            {
               scale *= 1.1;
            }
            else if ('x' == c)
            {
               xTranslation += 0.1;
            }
            else if ('X' == c)
            {
               xTranslation -= 0.1;
            }
            else if ('y' == c)
            {
               yTranslation += 0.1;
            }
            else if ('Y' == c)
            {
               yTranslation -= 0.1;
            }
            else if ('z' == c)
            {
               zTranslation += 0.1;
            }
            else if ('Z' == c)
            {
               zTranslation -= 0.1;
            }
            else if ('u' == c)
            {
               xRotation += 2.0;
            }
            else if ('U' == c)
            {
               xRotation -= 2.0;
            }
            else if ('v' == c)
            {
               yRotation += 2.0;
            }
            else if ('V' == c)
            {
               yRotation -= 2.0;
            }
            else if ('w' == c)
            {
               zRotation += 2.0;
            }
            else if ('W' == c)
            {
               zRotation -= 2.0;
            }

            // Set the model-to-view transformation matrix.
            // The order of the transformations is very important!
            Model model = scene.modelList.get(0);
            model.model2Identity();
            // Push the model away from where the camera is.
            model.modelTranslate(0, 0, -2);
            // Move the model relative to its new position.
            model.modelTranslate(xTranslation, yTranslation, zTranslation);
            model.modelRotate(xRotation, 1, 0, 0);
            model.modelRotate(yRotation, 0, 1, 0);
            model.modelRotate(zRotation, 0, 0, 1);
            model.modelScale(scale, scale, scale);

            // Set up the camera's view volume.
            if (scene.camera.perspective)
            {
               scene.camera.projPerspective();
               if (0 == perspProjMatrix1Index)
                  scene.camera.projMatrix = new PerspectiveProjectionMatrix1();
               else if (1 == perspProjMatrix1Index)
                  scene.camera.projMatrix = new PerspectiveProjectionMatrix2();
               else if (2 == perspProjMatrix1Index)
                  scene.camera.projMatrix = new PerspectiveProjectionMatrix3();
            }
            else
            {
               scene.camera.projOrtho();
            }
            if ('/'==c) System.out.print( scene.camera );

            // Render again.
            this.getFrameBuffer().clearFB(Color.black);
            Pipeline.render(scene, this.getFrameBuffer());
            repaint();
         }

         // Implement part of the ComponentListener interface.
         @Override public void componentResized(ComponentEvent e)
         {
            //System.out.println( e );
            java.awt.Container c = (java.awt.Container)e.getSource();
            java.awt.Insets insets = c.getInsets();
            int w = c.getWidth()  - insets.left - insets.right;
            int h = c.getHeight() - insets.top  - insets.bottom;

            this.createFrameBuffer(w, h);
            this.getFrameBuffer().clearFB(Color.black);
            Pipeline.render(scene, this.getFrameBuffer());
            repaint();
         }
      };

      app.addKeyListener(app);
      app.addComponentListener(app);
   }
}
