/*

*/
import scene.*;
import pipeline.*;
import framebuffer.*;

import java.awt.Color;
import java.awt.event.*;

/**
                   y
                   |
                   |
                   | v[1]
                 1 +
                   |
                   |
                   |
                   |
                   |
                   |
                   |
                   |                  v[0]
              v[2] +-----------------+------> x
                  /                  1
                /
              /
            /
         1 +
         / v[2]
       /
     /
    z

   Render a single wireframe triangle. This is just about
   the simplest possible model. It is useful for debugging.
*/
public class InteractiveTriangle_v7
{
   private static int perspProjMatrix1Index = 0;

   private static double xTranslation = 0.0;
   private static double yTranslation = 0.0;
   private static double zTranslation = 0.0;
   private static double xRotation = 0.0;
   private static double yRotation = 0.0;
   private static double zRotation = 0.0;
   private static double scale = 1.0;

   public static void main(String[] args)
   {
      System.out.println("Use the 'd' key to toggle debugging information on and off.");
      System.out.println("Use the 'p' key to toggle between parallel and orthographic projection.");
      System.out.println("Use the x/X, y/Y, z/Z, keys to translate the triangle along the x, y, z axes.");
      System.out.println("Use the u/U, v/V, w/W, keys to rotate the triangle around the x, y, z axes.");
      System.out.println("Use the s/S keys to scale the size of the triangle.");
      System.out.println("Use the 'c' key to change the random vertex colors.");
      System.out.println("Use the 'a' key to toggle antialiasing on and off.");
      System.out.println("Use the '/' key to cycle through the perspective projection matrices.");

      // Create a Model object to hold the geometry.
      final Model model = new Model();

      // Add the geometry (in model coordinates) to the Model.
      final Vertex[] v = new Vertex[3];

      v[0] = new Vertex(1.0, 0.0, 0.0);
      v[1] = new Vertex(0.0, 1.0, 0.0);
      v[2] = new Vertex(0.0, 0.0, 0.0);
    //v[2] = new Vertex(0.0, 0.0, 1.0);  // lands right on the camera

      v[0].setColorRandom();
      v[1].setColorRandom();
      v[2].setColorRandom();

      model.addLineSegment( new LineSegment(v[1], v[2]) );
      model.addLineSegment( new LineSegment(v[2], v[0]) );
      model.addLineSegment( new LineSegment(v[0], v[1]) );

      // Push the model away from where the camera is.
      model.modelTranslate(0, 0, -1);


      // Create the Scene object that we shall render.
      final Scene scene = new Scene();

      // Add the Model to the Scene.
      scene.addModel(model);


      // Create a Camera object.
      Camera camera = new Camera();

      // Add the Camera to the Scene.
      scene.setCamera(camera);


      // Create a InteractiveFrame and a FrameBuffer to render our scene into.
      int width  = 512;
      int height = 512;

      @SuppressWarnings("serial")
      final InteractiveFrame app = new InteractiveFrame("Renderer 7", width, height)
      {
         // Implement part of the KeyListener interface.
         @Override public void keyTyped(KeyEvent e)
         {
            //System.out.println( e );
            char c = e.getKeyChar();
            if ('d' == c)
            {
               Pipeline.debug = ! Pipeline.debug;
             //Pipeline.debug_visible = ! Pipeline.debug_visible;
             //Rasterize.debug = ! Rasterize.debug;
             //RasterizeAntialias.debug = ! RasterizeAntialias.debug;
            }
            else if ('/' == c)
            {
               perspProjMatrix1Index = (perspProjMatrix1Index + 1) % 3;
            }
            else if ('a' == c)
            {
               Pipeline.doAntialiasing = ! Pipeline.doAntialiasing;
            }
            else if ('c' == c)
            {
               // Change the random color at each vertex.
               for (int i = 0; i < v.length; i++)
               {
                  v[i].setColorRandom();
               }
            }
            else if ('p' == c)
            {
               if (scene.camera.perspective)
               {
                  scene.camera.projOrtho();
               }
               else
               {
                  scene.camera.projPerspective();
               }
            }
            else if ('s' == c) // Scale the triangle 10% smaller.
            {
               scale *= 0.9;
            }
            else if ('S' == c) // Scale the triangle 10% larger.
            {
               scale *= 1.1;
            }
            else if ('x' == c)
            {
               xTranslation += 0.1;
            }
            else if ('X' == c)
            {
               xTranslation -= 0.1;
            }
            else if ('y' == c)
            {
               yTranslation += 0.1;
            }
            else if ('Y' == c)
            {
               yTranslation -= 0.1;
            }
            else if ('z' == c)
            {
               zTranslation += 0.1;
            }
            else if ('Z' == c)
            {
               zTranslation -= 0.1;
            }
            else if ('u' == c)
            {
               xRotation += 2.0;
            }
            else if ('U' == c)
            {
               xRotation -= 2.0;
            }
            else if ('v' == c)
            {
               yRotation += 2.0;
            }
            else if ('V' == c)
            {
               yRotation -= 2.0;
            }
            else if ('w' == c)
            {
               zRotation += 2.0;
            }
            else if ('W' == c)
            {
               zRotation -= 2.0;
            }

            // Set the model-to-view transformation matrix.
            // The order of the transformations is very important!
            model.model2Identity();
            // Push the model away from where the camera is.
            model.modelTranslate(0, 0, -1);
            // Move the model relative to its new position.
            model.modelTranslate(xTranslation, yTranslation, zTranslation);
            model.modelRotate(xRotation, 1, 0, 0);
            model.modelRotate(yRotation, 0, 1, 0);
            model.modelRotate(zRotation, 0, 0, 1);
            model.modelScale(scale, scale, scale);

            // Set up the camera's view volume.
            if (scene.camera.perspective)
            {
               scene.camera.projPerspective();
               if (0 == perspProjMatrix1Index)
                  scene.camera.projMatrix = new PerspectiveProjectionMatrix1();
               else if (1 == perspProjMatrix1Index)
                  scene.camera.projMatrix = new PerspectiveProjectionMatrix2();
               else if (2 == perspProjMatrix1Index)
                  scene.camera.projMatrix = new PerspectiveProjectionMatrix3();
            }
            else
            {
               scene.camera.projOrtho();
            }
            if ('/'==c) System.out.print( scene.camera );

            // Render again.
            this.getFrameBuffer().clearFB(Color.black);
            Pipeline.render(scene, this.getFrameBuffer());
            repaint();
         }

         // Implement part of the ComponentListener interface.
         @Override public void componentResized(ComponentEvent e)
         {
            //System.out.println( e );
            java.awt.Container c = (java.awt.Container)e.getSource();
            java.awt.Insets insets = c.getInsets();
            int w = c.getWidth()  - insets.left - insets.right;
            int h = c.getHeight() - insets.top  - insets.bottom;

            this.createFrameBuffer(w, h);
            this.getFrameBuffer().clearFB(Color.black);
            Pipeline.render(scene, this.getFrameBuffer());
            repaint();
         }
      };

      app.addKeyListener(app);
      app.addComponentListener(app);
   }
}
