/*

*/
import scene.*;
import pipeline.*;
import framebuffer.*;

import java.awt.Color;

/**
   This program demonstrates a problem with the
   way color is interpolated across a line segment
   when using a perspective projection.

*/
public class SomethingWrong2
{
   public static void main(String[] args)
   {
      // Create a Model object to hold the geometry.
      final Model model = new Model();

      // Add the geometry (in model coordinates) to the Model.
      Vertex v0 = new Vertex( -1.0,   0.0,  -1.0  );
      Vertex v1 = new Vertex(  100.0, 0.0,  -102.0 );
      Vertex v2 = new Vertex( -1.0,   0.25, -1.0  );
      Vertex v3 = new Vertex(  1.0,   0.25, -1.0 );

      v0.setColor(Color.red);
      v1.setColor(Color.blue);
      v2.setColor(Color.red);
      v3.setColor(Color.blue);

      model.addLineSegment( new LineSegment(v0, v1) );
      model.addLineSegment( new LineSegment(v2, v3) );


      // Create the Scene object that we shall render.
      final Scene scene = new Scene();

      // Add the Model to the Scene.
      scene.addModel(model);


      // Create a Camera object.
      final Camera camera = new Camera();

      // Add the Camera to the Scene.
      scene.setCamera(camera);


      // Create a FrameBuffer to render our scene into.
      int width  = 512;
      int height = 512;
      FrameBuffer fb = new FrameBuffer(width, height);

      // Give the framebuffer a background color.
      fb.clearFB(java.awt.Color.black);
      // Render our scene into the frame buffer using a Perspective Projection.
      Pipeline.render(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( "SomethingWrong2.ppm" );
   }
}
