/*

*/
import scene.*;
import scene.models.*;
import pipeline.*;
import framebuffer.*;

import java.awt.Color;
import java.io.File;

/**
   This program shows that our renderer does
   not keep track of any depth information.

   This program draws two models, a sphere and
   a cow. The cow is inside the sphere. But the
   final image drawn by the renderer depends on
   what order the models are placed in the Scene's
   model list. Whatever model is second in the list
   is drawn over the model that is first in the list.
   So if the cow is second in the list, it gets drawn
   over the sphere and does not appear to be inside
   the sphere.

   The final image drawn by the renderer should not
   depend on the order in which models are placed in
   the scene's model list. The final image should
   instead depend on the order of the models in space.
*/
public class SomethingWrong3
{
   public static void main(String[] args)
   {
      Model m1 = new SphereModel(30, 30, 1);
      m1.setColor(Color.red);
      m1.modelTranslate(0, 0, -2);

      Model m2 = new ObjSimpleModel(new File("assets/cow.obj"));
      m2.setColor(Color.blue);
      // Place the cow in the middle of the sphere.
      m2.modelTranslate(0, 0, -2);


      // Create the Scene object that we shall render.
      final Scene scene = new Scene();

      // Add the Models to the Scene.
      scene.addModel(m1, m2);


      // Create a Camera object.
      final Camera camera = new Camera();

      // Add the Camera to the Scene.
      scene.setCamera(camera);


      // Create a FrameBuffer to render our scene into.
      int width  = 512;
      int height = 512;
      FrameBuffer fb = new FrameBuffer(width, height);

      // Give the framebuffer a background color.
      fb.clearFB(java.awt.Color.black);
      // Render our scene into the frame buffer.
      Pipeline.render(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( "SomethingWrong3a.ppm" );

      // Reverse the order of the two models in the scene's model list.
      Model temp = scene.modelList.remove(0);
      scene.addModel(temp);

      // Give the framebuffer a background color.
      fb.clearFB(java.awt.Color.black);
      // Render our scene into the frame buffer.
      Pipeline.render(scene, fb);
      // Save the resulting image in a file.
      fb.dumpFB2File( "SomethingWrong3b.ppm" );
   }
}
