/*

*/
package pipeline;
import scene.*;

/**
   Transform line segments from model coordinates to camera coordinates.

   For each Vertex object in each LineSgement object, use the Model's
   model matrix to transform the Vertex object's coordinate from the
   model's coordinate system to the camera's coordinate system.
*/
public class Model2Camera
{
   /**
      For each line segment, transform each vertex from
      model coordinates to camera coordinates.

      @param ls LineSegment to be transformed to camera coordinates
      @param modelMatrix transformation matrix
   */
   public static void model2camera(LineSegment ls, Matrix modelMatrix)
   {
      // Mutate each Vertex object so that it contains
      // the camera coordinates.
      ls.v[0].times(modelMatrix);
      ls.v[1].times(modelMatrix);
   }
}
