/*

*/
package pipeline;
import scene.*;

/**
   Do perspective division of a vertex in homogeneous
   coordinates,
      (x, y, z, w) -> (x/w, y/w, z/w, 1).

   This completes the projection operation that was
   only partially done by the camera's projection
   matrix. This stage of the pipeline leaves vertices
   lying in the standard camera view plane, z = -1,
   where they can be clipped.
*/
public class PerspectiveDivision
{
   /**
      For each line segment in the model, do the
      perspective division operation on the vertices.

      @param ls LineSegment to project into the camera's view plane
   */
   public static void perspectiveDivide(LineSegment ls)
   {
      // Mutate each Vertex object so that it contains
      // its perspective division.
      ls.v[0].perspectiveDivision( );
      ls.v[1].perspectiveDivision( );
   }
}
