/*

*/
package pipeline;
import scene.*;

/**
   Project line segments from camera coordinates to the homogeneous
   space z + w = 0.

   For each Vertex object in each LineSgement object, project the
   Vertex object so that it will perspectively divide into the
   standard view plane z = -1.

   Recall that the camera's projection matrix does not complete
   the projection (the vertices are not yet lying in the standard
   view plane). The next step in the pipeline, perspective division,
   completes the projection into the standard view plane.
*/
public class Project
{
   /**
      For each line segment in the model, transform each
      vertex, using the camera's projection matrix, into
      the homogeneous view space z + w = 0. Then, since
             z = -w
      so
           z/w = -1
      so the next pipeline stage, perspective division, will
      send each vertex to the standard view plane z = -1 where
      it can be clipped.


      @param ls LineSegment to project into homogeneous space
      @param projMatrix the projection matrix from the Scene's Camera
   */
   public static void project(LineSegment ls, Matrix projMatrix)
   {
      // Mutate each Vertex object so that it contains
      // the projected coordinates.
      ls.v[0].times(projMatrix);
      ls.v[1].times(projMatrix);
   }
}
