/*

*/
package scene;

import java.awt.Color;

/**
   A LineSegment object has two Vertex objects that represent the endpoints of the line segment.
*/
public class LineSegment
{
   public Vertex[] v = new Vertex[2]; // the vertices of this line segment

   /**
      Create a LineSegment object with references to the two given Vertex objects.

      @param v0 1st endpoint of the new LineSegment
      @param v1 2nd endpoint of the new LineSegment
   */
   public LineSegment(Vertex v0, Vertex v1)
   {
      v[0] = v0;
      v[1] = v1;
   }


   /**
      Create a LineSegment object with references to copies of the two
      Vertex objects in the given LineSegment object.

      Notice that this is a "deep copy" of the given LineSegment object.

      @param ls LineSegment to make a deep copy of
   */
   public LineSegment(LineSegment ls)
   {
      this( new Vertex(ls.v[0]), new Vertex(ls.v[1]) );
   }


   /**
      Give this LineSegment a uniform color.

      @param c Color for this LineSegment
   */
   public void setColor(Color c)
   {
      v[0].setColor(c);
      v[1].setColor(c);
   }

   /**
      Give this LineSegment a uniform, but randomly chosen, color.
   */
   public void setColorRandom()
   {
      v[0].setColorRandom();
      v[1].setColor(v[0]);
   }


   /**
      For debugging.

      @return String representation of this LineSegment object
   */
   public String toString()
   {
      String result = "Line Segment:\n";
      result += v[0].toString();
      result += v[1].toString();
      return result;
   }
}
