/*

*/
package scene;

/**
<pre>
   This is an orthographic (parallel) projection matrix.
     [ 1  0  0  0 ]
     [ 0  1  0  0 ]
     [ 0  0  0 -1 ]
     [ 0  0  0  1 ]
   Notice that this matrix maps
      (x, y, z, 1) -> (x, y, -1, 1)
   so it projects the camera space w = 1 onto the
   standard view plane z = -1.

   Notice that we can also say that the transformation
      (x, y, z, 1) -> (x, y, -1, 1)
   "projects" the camera space w = 1 onto the
   homogeneous plane w + z = 0.
</pre>
*/
public class OrthographicProjectionMatrix extends Matrix
{
   /**
   <pre>
      Construct this orthographic projection matrix.
        [ 1  0  0  0 ]
        [ 0  1  0  0 ]
        [ 0  0  0 -1 ]
        [ 0  0  0  1 ]
   </pre>
   */
   public OrthographicProjectionMatrix()
   {
      super(  new Vector(1.0, 0.0,  0.0, 0.0),
              new Vector(0.0, 1.0,  0.0, 0.0),
              new Vector(0.0, 0.0,  0.0, 0.0),
              new Vector(0.0, 0.0, -1.0, 1.0) );
   }
}
