/*

*/
package scene;

/**
<pre>
   This is a perspective projection matrix.
     [ 1  0  0  0 ]
     [ 0  1  0  0 ]
     [ 0  0  0  0 ]
     [ 0  0 -1  0 ]
   Notice that this matrix maps
      (x, y, z, 1) -> (x, y, 0, -z)
   so it "projects" the camera space w = 1 onto the
   homogeneous space z = 0.

   After the perspective division stage we get
      (x, y, 0, -z) -> (-x/z, -y/z, 0, 1)
   so we will have projected the camera space w = 1 onto
   the view plane z = 0.
</pre>
*/
public class PerspectiveProjectionMatrix2 extends Matrix
{
   /**
   <pre>
      Construct this perspective projection matrix.
        [ 1  0  0  0 ]
        [ 0  1  0  0 ]
        [ 0  0  0  0 ]
        [ 0  0 -1  0 ]
   </pre>
   */
   public PerspectiveProjectionMatrix2()
   {
      super(  new Vector(1.0, 0.0, 0.0,  0.0),
              new Vector(0.0, 1.0, 0.0,  0.0),
              new Vector(0.0, 0.0, 0.0, -1.0),
              new Vector(0.0, 0.0, 0.0,  0.0) );
   }
}
