/*

*/
package scene;

import java.util.List;
import java.util.LinkedList;

/**
    A Scene data structure is a list of Model data structures
    and a Camera data structure.
<p>
    Each Model object represents a distinct geometric object
    in the scene.
<p>
    The Camera object determines a "view volume", which
    determines how much of the scene is actually visible
    and gets rendered into the framebuffer.
*/
public class Scene
{
   public List<Model> modelList = new LinkedList<Model>();

   public Camera camera;


   /**
      Construct a scene with a default camera object.
   */
   public Scene()
   {
      this.camera = new Camera();
   }


   /**
      Construct a scene with the given camera object.

      @param camera Camera object for this Scene
   */
   public Scene(Camera camera)
   {
      this.camera = camera;
   }


   /**
      Change this scene's camera to the given camera object.

      @param camera new Camera object for this Scene
   */
   public void setCamera(Camera camera)
   {
      this.camera = camera;
   }


   /**
      Add a model (or models) to this scene.

      @param mArray array of Models to add to this Scene
   */
   public void addModel(Model... mArray)
   {
      for (Model model : mArray)
      {
         modelList.add(model);
      }
   }


   /**
      For debugging.

      @return String representation of this Scene object
   */
   public String toString()
   {
      String result = "";
      result += camera.toString();
      result += "This Scene has " + modelList.size() + " models\n";
      int i = 0;
      for (Model m : modelList)
      {
         result += "Model " + (i++) + "\n";
         result += m.toString();
      }
      return result;
   }
}
