/*

*/
package scene.models;
import scene.*;

/**
   An x and y axis in the xy-plane, along with "tick marks".
*/
public class Axes2DModel extends Model
{
   /**
      From -1 to +1 on each axis.
   */
   public Axes2DModel( )
   {
      this(-1, 1, -1, 1, 0.0, 5, 5);
   }


   /**
      Left and right end points for the x-axis.
      Bottom and top end points for the y-axis.
      Number of evenly spaced tick marks on the x-axis.
      Number of evenly spaced tick marks on the y-axis.
   */
   public Axes2DModel(double xMin, double xMax, double yMin, double yMax,
                      int xMarks, int yMarks)
   {
      this(xMin, xMax, yMin, yMax, 0.0, xMarks, yMarks);
   }


   /**
       The z parameter is so that you can put the axis just above
       or just below the xy-plane (say z=0.01 or z=-0.01). This way,
       the axes can be just in front of or just behind whatever is
       being drawn in the xy-plane.
   */
   public Axes2DModel(double xMin, double xMax, double yMin, double yMax,
                      double z, int xMarks, int yMarks)
   {
      super();

       // x-axis
      this.addLineSegment(new LineSegment(new Vertex(xMin, 0, z),
                                          new Vertex(xMax, 0, z)));

       // y-axis
      this.addLineSegment(new LineSegment(new Vertex(0, yMin, z),
                                          new Vertex(0, yMax, z)));

       // Put evenly spaced tick marks on the x-axis.
      double xDelta = (xMax - xMin)/xMarks;
      double yDelta = (yMax - yMin)/50;
      for (double x = xMin; x <= xMax; x += xDelta)
      {
         this.addLineSegment(new LineSegment(new Vertex(x,  yDelta/2, z),
                                             new Vertex(x, -yDelta/2, z)));
      }

       // Put evenly spaced tick marks on the y-axis.
      yDelta = (yMax - yMin)/yMarks;
      xDelta = (xMax - xMin)/50;
      for (double y = yMin; y <= yMax; y += yDelta)
      {
         this.addLineSegment(new LineSegment(new Vertex( xDelta/2, y, z),
                                             new Vertex(-xDelta/2, y, z)));
      }
   }
}
