/*

*/
package scene.models;
import scene.*;

import java.awt.Color;

/**
   A positive x, y, and z axis in 3-dimensional space.
*/
public class Axes3DModel extends Model
{
   /**
      One unit length for each axis.
      Default color of black.
   */
   public Axes3DModel( )
   {
      this(1.0, 0.0, 1.0, 0.0, 1.0, 0.0, Color.black, Color.black, Color.black);
   }


   /**
      End points for the positive x, y, and z axes.
      Default color of black.
   */
   public Axes3DModel(double xMax, double yMax, double zMax)
   {
      this(xMax, 0.0, yMax, 0.0, zMax, 0.0, Color.black, Color.black, Color.black);
   }


   /**
      End points for the positive x, y, and z axes.
      Use the given Color c.
   */
   public Axes3DModel(double xMax, double yMax, double zMax, Color c)
   {
      this(xMax, 0.0, yMax, 0.0, zMax, 0.0, c, c, c);
   }


   /**
      End points for the positive x, y, and z axes.
      Use the colors cX, cY, and cZ for the x, y, and z axes.
   */
   public Axes3DModel(double xMax, double yMax, double zMax,
                      Color cX,    Color cY,    Color cZ)
   {
      this(xMax, 0.0, yMax, 0.0, zMax, 0.0, cX, cY, cZ);
   }


   /**
      End points for the x, y, and z axes.
      Default color of black.
   */
   public Axes3DModel(double xMax, double xMin,
                      double yMax, double yMin,
                      double zMax, double zMin)
   {
      this(xMax, xMin, yMax, yMin, zMax, zMin, Color.black, Color.black, Color.black);
   }


   /**
      End points for the x, y, and z axes.
      Use the given Color c.
   */
   public Axes3DModel(double xMax, double xMin,
                      double yMax, double yMin,
                      double zMax, double zMin,
                      Color c)
   {
      this(xMax, xMin, yMax, yMin, zMax, zMin, c, c, c);
   }


   /**
      End points for the x, y, and z axes.
      Use the colors cX, cY, and cZ for the x, y, and z axes.
   */
   public Axes3DModel(double xMax, double xMin,
                      double yMax, double yMin,
                      double zMax, double zMin,
                      Color cX, Color cY, Color cZ)
   {
      super();

      Vertex x0 = new Vertex(xMin, 0,    0);
      Vertex x1 = new Vertex(xMax, 0,    0);
      Vertex y0 = new Vertex( 0,  yMin,  0);
      Vertex y1 = new Vertex( 0,  yMax,  0);
      Vertex z0 = new Vertex( 0,   0,   zMin);
      Vertex z1 = new Vertex( 0,   0,   zMax);

      LineSegment xAxis = new LineSegment(x0, x1);
      LineSegment yAxis = new LineSegment(y0, y1);
      LineSegment zAxis = new LineSegment(z0, z1);

      xAxis.setColor( cX );
      yAxis.setColor( cY );
      zAxis.setColor( cZ );

      this.addLineSegment( xAxis, yAxis, zAxis );
   }
}
