/*

*/
package scene.models;
import scene.*;

/**
   n number of line segments around the circle

   r radius of the circle
*/
public class CircleModel extends Model
{
   public CircleModel( )
   {
      this(12, 1);
   }


   public CircleModel(int n, double radius)
   {
      super();

      // Create the circle's geometry.

      // An array of vertices to be used to create line segments.
      Vertex[] v = new Vertex[n];

      // Create all the vertices.
      for (int j = 0; j < n; j++)
      {
         double c = Math.cos(j*(2.0*Math.PI)/n);
         double s = Math.sin(j*(2.0*Math.PI)/n);
         v[j] = new Vertex(radius*c, radius*s, 0);
      }

      // Create line segments around the circle.
      LineSegment ls;
      for (int i = 0; i < n - 1; i++)
      {
         ls = new LineSegment( new Vertex(v[i]), new Vertex(v[i+1]) );
         this.addLineSegment( ls );
      }
      ls = new LineSegment( new Vertex(v[n-1]), new Vertex(v[0]) );
      this.addLineSegment( ls );
   }
}//CircleModel
