/*

*/
package scene.models;
import scene.*;

/**
   k number of triangles in each triangle fan at the top and base of the cone
   n number of rectangle strips between the top and bottom triangle fans
   r radius of the base of the cone
   h height of the cone
*/
public class ConeModel extends Model
{
   public ConeModel( )
   {
	   this(3, 2, 1, 1);
   }


   public ConeModel(int k, int n, double radius, double h)
   {
      super();

      // Create the cone's geometry.

      // An array of vertices to be used to create line segments.
      Vertex[][] v = new Vertex[n+1][k];

      // Create all the vertices along the cone wall.
      for (int j = 0; j < k; j++)
      {
         double c = Math.cos(j*(2.0*Math.PI)/k);
         double s = Math.sin(j*(2.0*Math.PI)/k);
         for (int i = 0; i <= n; i++)
         {
            double slantRadius = ((double)(i+1)/(double)(n+1)) * radius;
            v[i][j] = new Vertex( slantRadius*c, h-(i+1)*h/(n+1), slantRadius*s );
         }
      }
      // Vertex at the center of the top.
      Vertex topCenter = new Vertex(0.0, h, 0.0);
      // Vertex at the center of the bottom.
      Vertex bottomCenter = new Vertex(0.0, 0.0, 0.0);


      // Create all the horizontal circles of latitude around the cone wall.
      LineSegment ls;
      for (int i = 0; i <= n; i++)
      {
         for (int j = 0; j < k-1; j++)
         {
            ls = new LineSegment( new Vertex(v[i][j]), new Vertex(v[i][j+1]) );
            this.addLineSegment( ls );
         }
         ls = new LineSegment( new Vertex(v[i][k-1]), new Vertex(v[i][0]) );
         this.addLineSegment( ls );
      }

      // Create the slant lines from the apex to the base.
      for (int j = 0; j < k; j++)
      {
         ls = new LineSegment( new Vertex(topCenter), new Vertex(v[n][j]) );
         this.addLineSegment( ls );
      }

      // Create the triangle fan at the base.
      for (int j = 0; j < k; j++)
      {
         ls = new LineSegment( new Vertex(bottomCenter), new Vertex(v[n][j]) );
         this.addLineSegment( ls );
      }
   }
}//ConeModel
