/*

*/
package scene.models;
import scene.*;

/**
   k   number of lines of longitude
   n+2 number of lines of latitude (there is always at least two)
   r1  radius of the base of the frustum
   r2  radius of the top of the frustum
   h   height of the frustum
*/
public class FrustumCircularModel extends Model
{
   public FrustumCircularModel( )
   {
	   this(3, 1, 0.5, 1.0, 1.0);
   }


   public FrustumCircularModel(int k, int n, double r1, double r2, double h)
   {
      super();

      // Create the frustum's geometry.

      // An array of vertices to be used to create line segments.
      Vertex[][] v = new Vertex[n+2][k];

      // Create all the vertices along the frustum wall.
      for (int j = 0; j < k; j++)
      {
         double c = Math.cos(j*(2.0*Math.PI)/k);
         double s = Math.sin(j*(2.0*Math.PI)/k);
         for (int i = 0; i <= n+1; i++)
         {
            double slantRadius = (i/(double)(n+1)) * r1 + ((n+1-i)/(double)(n+1)) * r2;
            v[i][j] = new Vertex( slantRadius*c, h-(i*h)/(n+1), slantRadius*s );
         }
      }
      // Vertex at the center of the top.
      Vertex    topCenter = new Vertex(0.0,   h, 0.0);
      // Vertex at the center of the bottom.
      Vertex bottomCenter = new Vertex(0.0, 0.0, 0.0);

      // Create all the horizontal circles of latitude around the frustum wall.
      LineSegment ls;
      for (int i = 0; i <= n+1; i++)
      {
         for (int j = 0; j < k-1; j++)
         {
            ls = new LineSegment( new Vertex(v[i][j]), new Vertex(v[i][j+1]) );
            this.addLineSegment( ls );
         }
         ls = new LineSegment( new Vertex(v[i][k-1]), new Vertex(v[i][0]) );
         this.addLineSegment( ls );
      }

      // Create the vertical half-trapazoids of longitude from the north to the south pole.
      for (int j = 0; j < k; j++)
      {
         // Create the triangle fan at the top.
         ls = new LineSegment( new Vertex(topCenter), new Vertex(v[0][j]) );
         this.addLineSegment( ls );

         // Create the slant lines from the top to the base.
         ls = new LineSegment( new Vertex(v[0][j]), new Vertex(v[n+1][j]) );
         this.addLineSegment( ls );

         // Create the triangle fan at the base.
         ls = new LineSegment( new Vertex(v[n+1][j]), new Vertex(bottomCenter) );
         this.addLineSegment( ls );
      }
   }
}//FrustumCircularModel
