/*

*/
package scene.models;
import scene.*;

/**
   Two constructors that mimic the projFrustum() and projPerspective()
   metods from the Camera class.
*/
public class FrustumRectagularModel extends Model
{
   public FrustumRectagularModel( )
   {
	   this(-0.25, 0.25, -0.25, 0.25, 0.25, 1);
   }


   public FrustumRectagularModel(double left, double right, double bottom, double top, double near, double far)
   {
      super();

      Vertex v1 = new Vertex(left,  top,    -near);
      Vertex v2 = new Vertex(right, top,    -near);
      Vertex v3 = new Vertex(right, bottom, -near);
      Vertex v4 = new Vertex(left,  bottom, -near);
      Vertex v5 = new Vertex( (left/near)*far,    (top/near)*far, -far);
      Vertex v6 = new Vertex((right/near)*far,    (top/near)*far, -far);
      Vertex v7 = new Vertex((right/near)*far, (bottom/near)*far, -far);
      Vertex v8 = new Vertex( (left/near)*far, (bottom/near)*far, -far);

      // near face
      this.addLineSegment( new LineSegment(new Vertex(v1), new Vertex(v2)) );
      this.addLineSegment( new LineSegment(new Vertex(v2), new Vertex(v3)) );
      this.addLineSegment( new LineSegment(new Vertex(v3), new Vertex(v4)) );
      this.addLineSegment( new LineSegment(new Vertex(v4), new Vertex(v1)) );
      // far face
      this.addLineSegment( new LineSegment(new Vertex(v5), new Vertex(v6)) );
      this.addLineSegment( new LineSegment(new Vertex(v6), new Vertex(v7)) );
      this.addLineSegment( new LineSegment(new Vertex(v7), new Vertex(v8)) );
      this.addLineSegment( new LineSegment(new Vertex(v8), new Vertex(v5)) );
      // lines from front to back
      this.addLineSegment( new LineSegment(new Vertex(v1), new Vertex(v5)) );
      this.addLineSegment( new LineSegment(new Vertex(v2), new Vertex(v6)) );
      this.addLineSegment( new LineSegment(new Vertex(v3), new Vertex(v7)) );
      this.addLineSegment( new LineSegment(new Vertex(v4), new Vertex(v8)) );
   }


   public FrustumRectagularModel(double fovy, double aspect, double near, double far)
   {
      super();

      double top    =  near * Math.tan((Math.PI/180.0)*fovy/2.0);
      double bottom = -top;
      double right  =  top * aspect;
      double left   = -top * aspect;

      Vertex v1 = new Vertex(left,  top,    -near);
      Vertex v2 = new Vertex(right, top,    -near);
      Vertex v3 = new Vertex(right, bottom, -near);
      Vertex v4 = new Vertex(left,  bottom, -near);
      Vertex v5 = new Vertex( (left/near)*far,    (top/near)*far, -far);
      Vertex v6 = new Vertex((right/near)*far,    (top/near)*far, -far);
      Vertex v7 = new Vertex((right/near)*far, (bottom/near)*far, -far);
      Vertex v8 = new Vertex( (left/near)*far, (bottom/near)*far, -far);

      // near face
      this.addLineSegment( new LineSegment(new Vertex(v1), new Vertex(v2)) );
      this.addLineSegment( new LineSegment(new Vertex(v2), new Vertex(v3)) );
      this.addLineSegment( new LineSegment(new Vertex(v3), new Vertex(v4)) );
      this.addLineSegment( new LineSegment(new Vertex(v4), new Vertex(v1)) );
      // far face
      this.addLineSegment( new LineSegment(new Vertex(v5), new Vertex(v6)) );
      this.addLineSegment( new LineSegment(new Vertex(v6), new Vertex(v7)) );
      this.addLineSegment( new LineSegment(new Vertex(v7), new Vertex(v8)) );
      this.addLineSegment( new LineSegment(new Vertex(v8), new Vertex(v5)) );
      // lines from front to back
      this.addLineSegment( new LineSegment(new Vertex(v1), new Vertex(v5)) );
      this.addLineSegment( new LineSegment(new Vertex(v2), new Vertex(v6)) );
      this.addLineSegment( new LineSegment(new Vertex(v3), new Vertex(v7)) );
      this.addLineSegment( new LineSegment(new Vertex(v4), new Vertex(v8)) );
   }
}//FrustumRectagularModel