/*

*/
package scene.models;
import scene.*;

/**
   This is a regular octahedron with side length 1.
   Its center is at the orgin and the center plane is the xz-plane.
   The 5th and 6th vertices are on the y-axis.

   http://en.wikipedia.org/wiki/Regular_octahedron
*/
public class OctahedronModel extends Model
{
   public OctahedronModel()
   {
      super();

      // Create the octahedron's geometry.
      double sqrt3 = Math.sqrt(3.0);
      double sqrt2 = Math.sqrt(2.0);
      Vertex[] v = new Vertex[6];
      v[0] = new Vertex( 0.5, 0,  0.5);  // four vertices around the center plane
      v[1] = new Vertex(-0.5, 0,  0.5);
      v[2] = new Vertex(-0.5, 0, -0.5);
      v[3] = new Vertex( 0.5, 0, -0.5);
      v[4] = new Vertex( 0,  1/sqrt2, 0);   // vertex at the top
      v[5] = new Vertex( 0, -1/sqrt2, 0);   // vertex at the bottom

      // Create 12 line segments.
      LineSegment[] ls = new LineSegment[12];

      int i = 0;
      // four line segments around the center plane
      ls[i++] = new LineSegment(new Vertex(v[0]), new Vertex(v[1]));
      ls[i++] = new LineSegment(new Vertex(v[1]), new Vertex(v[2]));
      ls[i++] = new LineSegment(new Vertex(v[2]), new Vertex(v[3]));
      ls[i++] = new LineSegment(new Vertex(v[3]), new Vertex(v[0]));

      // edges going to the top vertex
      ls[i++] = new LineSegment(new Vertex(v[0]), new Vertex(v[4]));
      ls[i++] = new LineSegment(new Vertex(v[1]), new Vertex(v[4]));
      ls[i++] = new LineSegment(new Vertex(v[2]), new Vertex(v[4]));
      ls[i++] = new LineSegment(new Vertex(v[3]), new Vertex(v[4]));

      // edges going to the bottom vertex
      ls[i++] = new LineSegment(new Vertex(v[0]), new Vertex(v[5]));
      ls[i++] = new LineSegment(new Vertex(v[1]), new Vertex(v[5]));
      ls[i++] = new LineSegment(new Vertex(v[2]), new Vertex(v[5]));
      ls[i++] = new LineSegment(new Vertex(v[3]), new Vertex(v[5]));

      // Add the new line segments to the model.
      for (i = 0; i < ls.length; i++)
      {
         this.addLineSegment( ls[i] );
      }
   }
}//OctahedronModel
