/*

*/
package scene.models;
import scene.*;

import java.awt.Color;

/**
   A flat panel in the xz-plane.
*/
public class PanelModel extends Model
{
   public PanelModel( )
   {
	   this(-1, 1, -1, 1);
   }


   public PanelModel(int xMin, int xMax, int zMin, int zMax)
   {
      super();

      // Create the panel's geometry.

      // Two arrays of vertices to be used to create line segments.
      Vertex[][] vbf = new Vertex[(xMax-xMin)+1][2];  // back and front edges
      Vertex[][] vlr = new Vertex[(zMax-zMin)+1][2];  // left and right edges

      // Create all the vertices along the back and front edges.
      for (int x = xMin; x <= xMax; x++)
      {
         vbf[x-xMin][0] = new Vertex(x, 0, zMin);  // back edge
         vbf[x-xMin][1] = new Vertex(x, 0, zMax); // front edge
      }

      // Create all the vertices along the left and right edges.
      for (int z = zMin; z <= zMax; z++)
      {
         vlr[z-zMin][0] = new Vertex(xMin, 0, z);  // left edge
         vlr[z-zMin][1] = new Vertex(xMax, 0, z); // right edge
      }

      // Create the line segments that run in the z-direction.
      for (int x = 0; x <= xMax-xMin; x++)
      {
         LineSegment ls = new LineSegment(new Vertex(vbf[x][0]), new Vertex(vbf[x][1]));
         this.addLineSegment( ls );
      }

      // Create the line segments that run in the x-direction.
      for (int z = 0; z <= zMax-zMin; z++)
      {
         LineSegment ls = new LineSegment(new Vertex(vlr[z][0]), new Vertex(vlr[z][1]));
         this.addLineSegment( ls );
      }
   }
}
