/*

*/
package scene.models;
import scene.*;

/**
   k number of triangles in each triangle fan at the top and the bottom
   n number of rectangle strips between the top and bottom triangle fans

   r radius of the sphere
*/
public class SphereModel extends Model
{
   public SphereModel( )
   {
	   this(6, 6, 1);
   }


   public SphereModel(int k, int n, double radius)
   {
      super();

      // Create the sphere's geometry.

      // An array of vertices to be used to create line segments.
      Vertex[][] v = new Vertex[n+1][k];

      // Create all the vertices.
      for (int j = 0; j < k; j++)
      {
         double c1 = Math.cos(j*(2.0*Math.PI)/k);
         double s1 = Math.sin(j*(2.0*Math.PI)/k);
         for (int i = 0; i <= n; i++)
         {
            double c2 = Math.cos((i+1)*Math.PI/(n+2));
            double s2 = Math.sin((i+1)*Math.PI/(n+2));
            v[i][j] = new Vertex(radius*s2*c1,
                                 radius*c2,
                                 radius*s2*s1);
         }
      }
      Vertex    topPole = new Vertex(0.0,  radius, 0.0);
      Vertex bottomPole = new Vertex(0.0, -radius, 0.0);


      // Create all the horizontal circles of latitude around the sphere.
      LineSegment ls;
      for (int i = 0; i < n; i++)
      {
         for (int j = 0; j < k-1; j++)
         {
            ls = new LineSegment( new Vertex(v[i][j]), new Vertex(v[i][j+1]) );
            this.addLineSegment( ls );
         }
         ls = new LineSegment( new Vertex(v[i][k-1]), new Vertex(v[i][0]) );
         this.addLineSegment( ls );
      }

      // Create the vertical half-circles of longitude from the north to the south pole.
      for (int j = 0; j < k; j++)
      {
         ls = new LineSegment( new Vertex(topPole), new Vertex(v[0][j]) );
         this.addLineSegment( ls );

         for (int i = 0; i < n; i++)
         {
            ls = new LineSegment( new Vertex(v[i][j]), new Vertex(v[i+1][j]) );
            this.addLineSegment( ls );
         }

         ls = new LineSegment( new Vertex(v[n][j]), new Vertex(bottomPole) );
         this.addLineSegment( ls );
      }
   }
}//SphereModel
