/*

*/
import scene.*;
import scene.models.*;
import pipeline.*;
import framebuffer.*;

import java.awt.Color;
import java.awt.event.*;

/**
   Draw an animation of a solar system with a sun, earth, and moon..

   In this version, the earth orbits around the sun at the same rate as the sun
   rotates on its axis. Similarly, the moon orbits around the earth at the same
   rate as the earth rotates on its axis.

   But the orbit of the earth should be independent of the rotation of the sun,
   and the orbit of the moon should be independent of the rotation of the earth.


               SolarSystem
               /   |   \
             /     |     \
        matrix   geom    sub-models
          R     (sun)        |
                             |
                        earth-moon
                           / | \
                         /   |   \
                   matrix  geom   sub-models
                     TR   (earth)     |
                                      |
                                    moon
                                   /   \
                                 /       \
                             matrix      geom
                               TR       (moon)
*/
public class SolarSystem
{
   private static double earthOrbitRad = 5.0;
   private static double  moonOrbitRad = 1.0;

   private static double earthOrbitRot = 0.0;
   private static double  moonOrbitRot = 0.0;

   private static double  moonAxisRot = 0.0;

   public static void main(String[] args)
   {
      /*
         See the above picture of the tree that this code creates.
      */
      Model solarSys = new SphereModel(10, 10, 1.0);

      solarSys.addSubModel( new SphereModel(10, 10, 0.5) );

      solarSys.getSubModel(0).addSubModel( new SphereModel(10, 10, 0.2) );

      solarSys.setColor( Color.yellow );
      solarSys.getSubModel(0).setColor( Color.green );
      solarSys.getSubModel(0).getSubModel(0).setColor( Color.blue );


      // Create the Scene object that we shall render
      Scene scene = new Scene();

      // Add the model to the Scene.
      scene.modelList.add(solarSys);


      // Create a Camera object.
      Camera camera = new Camera();

      // Add the Camera to the Scene.
      scene.setCamera(camera);


      // Create a InteractiveFrame (with a FrameBuffer) to render our scene into.
      int width  = 512;
      int height = 512;
      @SuppressWarnings("serial")
      final InteractiveFrame app = new InteractiveFrame("Renderer 6", width, height)
      {
         // Implement part of the ComponentListener interface.
         @Override public void componentResized(ComponentEvent e)
         {
          //System.out.println( e );
            java.awt.Container c = (java.awt.Container)e.getSource();
            java.awt.Insets insets = c.getInsets();
            int w = c.getWidth()  - insets.left - insets.right;
            int h = c.getHeight() - insets.top  - insets.bottom;

            this.createFrameBuffer(w, h);
            this.getFrameBuffer().clearFB(Color.black);
            Pipeline.render(scene, this.getFrameBuffer());
            repaint();
         }
      };

      app.addComponentListener(app);

      // Create references to the sub-models
      Model earthMoon = solarSys.getSubModel(0);
      Model moon = earthMoon.getSubModel(0);

      while(true)
      {
         // Set the model-to-view transformation matrix.
         solarSys.model2Identity();
         // Push the model away from where the camera is.
         solarSys.modelTranslate(0, 0, -8);
         // Rotate the plane of the ecliptic
         // (rotate the model's plane about the x axis by fifteen degrees).
         solarSys.modelRotate(15, 1,0,0);

         // Set the model matrices for the sub models.
         solarSys.modelRotate(earthOrbitRot, 0,1,0);

         earthMoon.model2Identity();
         earthMoon.modelTranslate(earthOrbitRad, 0, 0);
         earthMoon.modelRotate(moonOrbitRot, 0,1,0);

         moon.model2Identity();
         moon.modelTranslate(moonOrbitRad, 0, 0);
         moon.modelRotate(moonAxisRot, 0,1,0);

         // Render again.
         app.getFrameBuffer().clearFB(Color.black);
         Pipeline.render(scene, app.getFrameBuffer());
         app.repaint();
         try{Thread.sleep(100);}catch(InterruptedException e){return;}

         // Update the parameters for the next frame.
         moonAxisRot += 18.0;

         earthOrbitRot += 1.0;
         moonOrbitRot += 15.0;
      }
   }
}
