/*

*/

import renderer.scene.*;
import renderer.models_TP.*; // models using higher order triangle primitivess
import renderer.pipeline.*;
import renderer.framebuffer.*;

import java.awt.Color;
import java.io.File;

/**
   Compare with
      http://threejs.org/examples/#webgl_geometries
<p>
   This version moves the camera around the array of models.
*/
public class Geometries_R18
{
   public static void main(String[] args)
   {
      // Create the Scene object that we shall render.
      Scene scene = new Scene();

      // Create a two-dimensional array of Positions holding Models.
      Position[][] position = new Position[3][5];

      // row 0
      position[0][0] = new Position(new ObjSimpleModel(new File("assets/great_rhombicosidodecahedron.obj")));
      position[0][0].model.setRandomPrimitiveColors();
    //position[0][0].model.setColor(Color.red);

      position[0][1] = new Position(new ConeFrustum(0.5, 1.0, 1.0, 10, 10, false));
      position[0][1].model.setRandomPrimitiveColors();
    //position[0][1].model.setColor(Color.orange);

      position[0][2] = new Position(new Box(1.0, 1.0, 1.0));
      position[0][2].model.setRandomPrimitiveColors();
    //position[0][2].model.setColor(Color.lightGray);

      position[0][3] = new Position(new Axes3D(1, 1, 1, Color.red, Color.green, Color.blue));

      position[0][4] = new Position(new Sphere(1.0, 30, 30));
      position[0][4].model.setRandomPrimitiveColors();
    //position[0][4].model.setColor(Color.lightGray);

      // row 1
      position[1][0] = new Position(new Cylinder(0.5, 1.0, 30, 30));
      position[1][0].model.setRandomPrimitiveColors();
    //position[1][0].model.setColor(Color.blue.brighter().brighter());

      position[1][1] = new Position(new ObjSimpleModel(new File("assets/horse.obj")));
      position[1][1].model.setColor(Color.pink);

      position[1][2] = new Position(new GRSModel(new File("assets/grs/vinci.grs")));
      position[1][2].model.setColor(Color.blue);

      position[1][3] = new Position(new Tetrahedron());
      position[1][3].model.setRandomPrimitiveColors();
    //position[1][3].model.setColor(Color.cyan);

      position[1][4] = new Position(new ObjSimpleModel(new File("assets/small_rhombicosidodecahedron.obj")));
      position[1][4].model.setRandomPrimitiveColors();
    //position[1][4].model.setColor(Color.magenta);

      // row 2
      position[2][0] = new Position(new TriangularPrism(1.0, 1.0, 10));
      position[2][0].model.setRandomPrimitiveColors();
    //position[2][0].model.setColor(Color.green.darker().darker());

      position[2][1] = new Position(new GRSModel(new File("assets/grs/bronto.grs")));
      position[2][1].model.setColor(Color.red);

      position[2][2] = new Position(new Torus(0.75, 0.25, 30, 30));
      position[2][2].model.setRandomColors();

      position[2][3] = new Position(new Octahedron());
      position[2][3].model.setRandomPrimitiveColors();
    //position[2][3].model.setColor(Color.blue);

      position[2][4] = new Position(new Cone(0.5, 1.0, 30, 30));
      position[2][4].model.setColor(Color.yellow);

      // Create x, y and z axes
      Position xyzAxes = new Position(new Axes3D(6, -6, 6, 0, 7, -7,  Color.red));

      // Create a horizontal coordinate plane model.
      Position xzPlane = new Position(new renderer.models_F.PanelXZ(-6, 6, -7, 7));
      xzPlane.model.setColor(Color.darkGray);

      // Add the positions (and their models) to the Scene.
      for (int i = 0; i < position.length; i++)
         for (int j = 0; j < position[i].length; j++)
         {
            scene.addPosition(position[i][j]);
         }
      scene.addPosition(xyzAxes);
      scene.addPosition(xzPlane);

      // Set up the camera's view frustum.
      double right  = 2.0;
      double left   = -right;
      double top    = 1.0;
      double bottom = -top;
      double near   = 1.0;
      double far    = 20.0;
      scene.camera.projPerspective(left, right, bottom, top, near, far);
/*
      double fov    = 90.0;
      double aspect = 2.0;
      double near   = 1.0;
      double far    = 20.0;
      scene.camera.projPerspective(fov, aspect, near, far);
*/
      // Create a framebuffer to render our scene into.
      int vp_width  = 1200;
      int vp_height = 600;
      FrameBuffer fb = new FrameBuffer(vp_width, vp_height);

      long startTime, stopTime;
      startTime = System.currentTimeMillis();
      for (int k = 0; k < 360; k++)
      {
         // Position the camera (move it around the periphery of the scene).
         scene.camera.view2Identity();
         scene.camera.viewRotate(-k, 0,1,0);
         scene.camera.viewTranslate(0, 3, 10);

         // Place each model in the xz-plane and
         // also rotate each model on its own axis.
         for (int i = 0; i < position.length; i++)
         {
            for (int j = 0; j < position[i].length; j++)
            {
               position[i][j].matrix2Identity();
               // Place the model where it belongs in the plane.
               position[i][j].translate(4-4*i, 0, 6-3*j);
               // Rotate the model on its own axis.
               position[i][j].rotateX(3*k);
               position[i][j].rotateY(3*k);
            }
         }

         // Render
       //Renderer.doAntialiasing = true;
         fb.clearFB(Color.black);
         Pipeline.render(scene, fb);
         fb.dumpFB2File(String.format("PPM_Geometries_R14_Frame%03d.ppm", k));
       //fb.dumpFB2File(String.format("PNG_Geometries_R14_Frame%03d.png", k), "png");
      }
      stopTime = System.currentTimeMillis();
      System.out.println("Wall-clock time: " + (stopTime - startTime));
   }
}
