/*

*/

import renderer.scene.*;
import renderer.scene.primitives.*;
import renderer.models_TP.SierpinskiTriangle;
import renderer.pipeline.*;
import renderer.framebuffer.*;
import renderer.gui.*;

import java.awt.Color;
import java.awt.event.*;
import java.util.ArrayList;

/**


*/
@SuppressWarnings("serial")
public class InteractiveSierpinskiTriangle_R18 extends InteractiveFrame
{
   private double fovy = 90.0;
   private boolean changePerspectiveVolumeWithNear = true;

   private boolean render_z_buffer = false;

   private boolean doBackFaceCulling = false;
   private boolean frontFacingIsCCW = true;
   private boolean facesHaveTwoSides = true;
   private Color   backFaceColor = new Color(150, 200, 150); // light green

   private double eyeX = 0.0;
   private double eyeY = 0.0;
   private double eyeZ = 2.0;
   private double eyeRotX = 0.0;
   private double eyeRotY = 0.0;
   private double eyeRotZ = 0.0;

   private boolean letterbox = false;
   private double aspectRatio = 1.0;
   private double far    =  2.0;
   private double near   =  1.0;
   private double left   = -1.0;
   private double right  =  1.0;
   private double bottom = -1.0;
   private double top    =  1.0;
   private boolean showCamera = false;

   private boolean showMatrix = false;
   private double xTranslation = 0.0;
   private double yTranslation = 0.0;
   private double zTranslation = 0.0;
   private double xRotation = 0.0;
   private double yRotation = 0.0;
   private double zRotation = 0.0;
   private double scale = 1.0;
   private boolean xSubRotation1 = false;
   private boolean xSubRotation2 = false;
   private boolean ySubRotation1 = false;
   private boolean ySubRotation2 = false;
   private boolean zSubRotation1 = false;
   private boolean zSubRotation2 = false;

   private Scene scene;

   /**
      This constructor instantiates the Scene object
      and initializes it with appropriate geometry.
   */
   public InteractiveSierpinskiTriangle_R18(String title, int fbWidth, int fbHeight)
   {
      super(title, fbWidth, fbHeight);

      // Create the Scene object that we shall render.
      scene = new Scene();

      // Create the Model object.
      Model model = new SierpinskiTriangle(7);

      // Create a Position for the Model.
      Position position = new Position(model);

      // Add the Position (and its Model) to the Scene.
      scene.addPosition(position);
      setBackFaceCulling(position, doBackFaceCulling);
      setFrontFacingIsCCW(position, frontFacingIsCCW);
      setFacesHaveTwoSides(position, facesHaveTwoSides);

      // Set up the camera's location and orientation.
      scene.camera.viewTranslate(eyeX, eyeY, eyeZ);

      // Give the model a random color.
      model.setRandomColor();
      // Give all Face and Triangle objects a back face color.
      model.setBackFaceColor(backFaceColor);
   }


   // Implement part of the KeyListener interface.
   @Override public void keyPressed(KeyEvent e)
   {
      //System.out.println( e );

      int keyCode = e.getKeyCode();
      // Only handle the four arrow keys.
      if (KeyEvent.VK_UP == keyCode   || KeyEvent.VK_DOWN == keyCode
       || KeyEvent.VK_LEFT == keyCode || KeyEvent.VK_RIGHT == keyCode)
      {
         if (KeyEvent.VK_UP == keyCode && e.getModifiers() != 0 )
         {
            eyeRotX += 1;
         }
         else if (KeyEvent.VK_DOWN == keyCode && e.getModifiers() != 0 )
         {
            eyeRotX -= 1;
         }
         else if (KeyEvent.VK_LEFT == keyCode && e.getModifiers() != 0 )
         {
            eyeRotY += 1;
         }
         else if (KeyEvent.VK_RIGHT == keyCode && e.getModifiers() != 0 )
         {
            eyeRotY -= 1;
         }
         else if (KeyEvent.VK_UP == keyCode)
         {
            eyeY += 0.1;
         }
         else if (KeyEvent.VK_DOWN == keyCode)
         {
            eyeY -= 0.1;
         }
         else if (KeyEvent.VK_LEFT == keyCode)
         {
            eyeX -= 0.1;
         }
         else if (KeyEvent.VK_RIGHT == keyCode)
         {
            eyeX += 0.1;
         }

         // Set up the camera's location and orientation.
         scene.camera.view2Identity();
         scene.camera.viewTranslate(eyeX, eyeY, eyeZ);
         scene.camera.viewRotateX(eyeRotX);
         scene.camera.viewRotateY(eyeRotY);

         if (showCamera)
         {
            System.out.println("eyeRotX = " + eyeRotX
                           + ", eyeRotY = " + eyeRotY);
            System.out.print( scene.camera.viewMatrix );
         }

         // Render again.
         setupViewport();
      }
   }


   @Override public void keyTyped(KeyEvent e)
   {
      //System.out.println( e );

      char c = e.getKeyChar();
      if ('h' == c)
      {
         print_help_message();
         return;
      }
      else if ('d' == c)
      {
         Pipeline.debug = ! Pipeline.debug;
       //Clip.debug = ! Clip.debug;
       //Rasterize.debug = ! Rasterize.debug;
      }
      else if (' ' == c)
      {
         render_z_buffer = ! render_z_buffer;
      }
      else if ('g' == c)
      {
         doBackFaceCulling = ! doBackFaceCulling;
         setBackFaceCulling(scene.positionList.get(0), doBackFaceCulling);
         System.out.print("Back face culling is ");
         System.out.println(doBackFaceCulling ? "on" : "off");
      }
      else if ('G' == c)
      {
         frontFacingIsCCW = ! frontFacingIsCCW;
         setFrontFacingIsCCW(scene.positionList.get(0), frontFacingIsCCW);
         System.out.print("Front face is ");
         System.out.println(frontFacingIsCCW ? "CCW" : "CW");
      }
      else if ('t' == c)
      {
         facesHaveTwoSides = ! facesHaveTwoSides;
         setFacesHaveTwoSides(scene.positionList.get(0), facesHaveTwoSides);
         System.out.print("Faces have two sides is ");
         System.out.println(facesHaveTwoSides ? "On" : "Off");
      }
      else if ('P' == c)
      {
         scene.positionList.get(0).model.toPointCloud(2);
      }
      else if ('f' == c || 'F' == c)
      {
         // Move the camera's far plane.
         if ('f' == c)
         {
            far -= 0.01;
         }
         else
         {
            far += 0.01;
         }
      }
      else if ('n' == c || 'N' == c)
      {
         // Move the camera's near plane.
         if ('n' == c)
         {
            near -= 0.01;
         }
         else
         {
            near += 0.01;
         }
         // use the near plane to set the camera's field-of-view
         if (scene.camera.perspective)
         {
            if ( changePerspectiveVolumeWithNear )
            {
               fovy = 2.0 * (180./Math.PI) * Math.atan(top/near);
            }
            else
            {
               top = near * Math.tan((Math.PI/180.0)*fovy/2.0);
            }
         }
         else  // orthographic projection
         {
            fovy = 2.0 * (180./Math.PI) * Math.atan(top/near);
         }
      }
      else if ('r' == c || 'R' == c)
      {
         // Change the aspect ratio of the camera's view rectangle.
         if ('r' == c)
         {
            aspectRatio -= 0.1;
         }
         else
         {
            aspectRatio += 0.1;
         }

         // Adjust right and left.
         // (Keep the vertical field-of-view fixed.)
         right =  top * aspectRatio;
         left  = -right;
      }
      else if ('o' == c || 'O' == c)
      {
         // Change left, right, bottom, and top.
         // (Keep the aspect ratio fixed.)
         if ('o' == c)
         {
            left   += 0.1 * aspectRatio;
            right  -= 0.1 * aspectRatio;
            bottom += 0.1;
            top    -= 0.1;
         }
         else
         {
            left   -= 0.1 * aspectRatio;
            right  += 0.1 * aspectRatio;
            bottom -= 0.1;
            top    += 0.1;
         }

         // Update the camera's vertical field-of-view.
         fovy = 2.0 * (180./Math.PI) * Math.atan(top/near);
      }
      else if ('D' == c)// Decouple perspective camera's view volume from near.
      {
         changePerspectiveVolumeWithNear = ! changePerspectiveVolumeWithNear;
         if ( changePerspectiveVolumeWithNear )
         {
            System.out.println("The perspective view volume will change with near plane.");
         }
         else
         {
            System.out.println("The perspective view volume will NOT change with near plane.");
         }
      }
      else if ('l' == c)
      {
         letterbox = ! letterbox;
      }
      else if ('c' == c)
      {
         // Change the solid random color of the triangle.
         scene.positionList.get(0).model.setRandomColor();
         scene.positionList.get(0).model.setBackFaceColor(backFaceColor);
      }
      else if ('C' == c)
      {
         // Change each color in the triangle to a random color.
         scene.positionList.get(0).model.setRandomColors();
         scene.positionList.get(0).model.setBackFaceColor(backFaceColor);
      }
      else if ('e' == c)
      {
         // Change the solid random color of each edge of the triangle.
         scene.positionList.get(0).model.setRandomPrimitiveColors();
         scene.positionList.get(0).model.setBackFaceColor(backFaceColor);
      }
      else if ( 'e' == c && (e.isControlDown() || e.isAltDown()) )
      {
         // Change the random color of each vertex of the triangle.
         scene.positionList.get(0).model.setRandomVertexColors();
         scene.positionList.get(0).model.setBackFaceColor(backFaceColor);
      }
      else if ('E' == c)
      {
         // Change the random color of each end of each edge of the triangle.
         scene.positionList.get(0).model.setRainbowPrimitiveColors();
         scene.positionList.get(0).model.setBackFaceColor(backFaceColor);
      }
      else if ('a' == c)
      {
         Pipeline.doAntialiasing = ! Pipeline.doAntialiasing;
      }
      else if ('p' == c)
      {
         scene.camera.perspective = ! scene.camera.perspective;
      }
      else if ('M' == c)
      {
         showCamera = ! showCamera;
      }
      else if ('m' == c)
      {
         showMatrix = ! showMatrix;
      }
      else if ('s' == c) // Scale the cube 10% smaller.
      {
         scale /= 1.1;
      }
      else if ('S' == c) // Scale the cube 10% larger.
      {
         scale *= 1.1;
      }
      else if ('x' == c)
      {
         xTranslation -= 0.1;
      }
      else if ('X' == c)
      {
         xTranslation += 0.1;
      }
      else if ('y' == c)
      {
         yTranslation -= 0.1;
      }
      else if ('Y' == c)
      {
         yTranslation += 0.1;
      }
      else if ('z' == c)
      {
         zTranslation -= 0.1;
      }
      else if ('Z' == c)
      {
         zTranslation += 0.1;
      }
      else if ('u' == c)
      {
         xRotation -= 2.0;
      }
      else if ('U' == c)
      {
         xRotation += 2.0;
      }
      else if ('v' == c)
      {
         yRotation -= 2.0;
      }
      else if ('V' == c)
      {
         yRotation += 2.0;
      }
      else if ('w' == c)
      {
         zRotation -= 2.0;
      }
      else if ('W' == c)
      {
         zRotation += 2.0;
      }
      else if ('1' == c)
      {
         xSubRotation1 = true;
      }
      else if ('!' == c)
      {
         xSubRotation2 = true;
      }
      else if ('2' == c)
      {
         ySubRotation1 = true;
      }
      else if ('@' == c)
      {
         ySubRotation2 = true;
      }
      else if ('3' == c)
      {
         zSubRotation1 = true;
      }
      else if ('#' == c)
      {
         zSubRotation2 = true;
      }
      else if ('4' == c)
      {
         scene.positionList.get(0).model.setRandomNestedModelColors();
      }

      // Update the nested matrices within the hierarchical model.
      Matrix m = Matrix.identity();
      if (xSubRotation1)
         m = Matrix.rotateX(2.0);
      else if (xSubRotation2)
         m = Matrix.rotateX(-2.0);
      else if (ySubRotation1)
         m = Matrix.rotateY(2.0);
      else if (ySubRotation2)
         m = Matrix.rotateY(-2.0);
      else if (zSubRotation1)
         m = Matrix.rotateZ(2.0);
      else if (zSubRotation2)
         m = Matrix.rotateZ(-2.0);
      xSubRotation1 = false;
      xSubRotation2 = false;
      ySubRotation1 = false;
      ySubRotation2 = false;
      zSubRotation1 = false;
      zSubRotation2 = false;
      for (Model model : scene.positionList.get(0).model.nestedModels)
      {
         updateNestedMatrices(model, m);
      }

      // Set the model-to-world transformation matrix.
      // The order of the transformations is very important!
      Position cube_p = scene.positionList.get(0);
      cube_p.matrix2Identity();
      // Move the model relative to its new position.
      cube_p.translate(xTranslation, yTranslation, zTranslation);
      cube_p.rotateX(xRotation);
      cube_p.rotateY(yRotation);
      cube_p.rotateZ(zRotation);
      cube_p.scale(scale);

      // Set up the camera's view volume.
      if (scene.camera.perspective)
      {
         scene.camera.projPerspective(fovy, aspectRatio, near, far);
      }
      else
      {
         scene.camera.projOrtho(fovy, aspectRatio, near, far);
      }

      if (showCamera && ('M'==c
           ||'n'==c||'N'==c||'o'==c||'O'==c||'r'==c||'R'==c||'p'==c))
      {
         System.out.print( scene.camera );
      }

      if (showMatrix && ('m'==c
           ||'s'==c||'x'==c||'y'==c||'z'==c||'u'==c||'v'==c||'w'==c
           ||'S'==c||'X'==c||'Y'==c||'Z'==c||'U'==c||'V'==c||'W'==c))
      {
         System.out.println("xRot = " + xRotation
                        + ", yRot = " + yRotation
                        + ", zRot = " + zRotation);
         System.out.print( cube_p.modelMatrix );
      }

      // Render again.
      setupViewport();
   }


   // Apply the given Matrix to the nested models within the given Model.
   private static void updateNestedMatrices(Model model, Matrix matrix)
   {
      //if (model.nestedModels.isEmpty()) // only rotate the leaf models
      {
         model.nestedMatrix = model.nestedMatrix.times(matrix);
      }
      for (Model m : model.nestedModels)
      {
         updateNestedMatrices( m, matrix);
      }
   }


   // Implement part of the ComponentListener interface.
   @Override public void componentResized(ComponentEvent e)
   {
      //System.out.println( e );

      // Get the new size of the FrameBufferPanel.
      int w = this.fbp.getWidth();
      int h = this.fbp.getHeight();

      // Create a new FrameBuffer that fits the new window size.
      FrameBuffer fb = new FrameBuffer(w, h);
      this.fbp.setFrameBuffer(fb);

      // Render again.
      setupViewport();
   }


   // Get in one place the code to set up the viewport.
   private void setupViewport()
   {
      // Render again.
      // Get the size of the FrameBuffer.
      FrameBuffer fb = this.fbp.getFrameBuffer();
      int w = fb.getWidthFB();
      int h = fb.getHeightFB();
      // Create a viewport with the correct aspect ratio.
      if ( letterbox )
      {
         if ( aspectRatio <= w/(double)h )
         {
            int width = (int)(h*aspectRatio);
            int xOffset = (w - width)/2;
            fb.setViewport(xOffset, 0, width, h);
         }
         else
         {
            int height = (int)(w/aspectRatio);
            int yOffset = (h - height)/2;
            fb.setViewport(0, yOffset, w, height);
         }
         fb.clearFB(Color.darkGray);
         fb.clearVP(Color.black);
      }
      else // the viewport is the whole framebuffer
      {
         fb.clearFB(Color.black);
         fb.setViewport();
      }
      Pipeline.render(scene, fb);
      if ( render_z_buffer )
      {
         FrameBuffer zBuf = this.fbp.getFrameBuffer().convertZB2FB();
         this.fbp.getFrameBuffer().setViewport(0, 0, zBuf);
      }
      fbp.update();
      repaint();
   }


   /**
      Create an instance of this class which has
      the affect of creating the GUI application.
   */
   public static void main(String[] args)
   {
      print_help_message();

      // Define initial dimensions for a FrameBuffer.
      int width  = 1024;
      int height = 1024;
      // Create an InteractiveFrame containing a FrameBuffer
      // with the given dimensions. NOTE: We need to call the
      // InteractiveSierpinskiTriangle_R18 constructor in the Java GUI Event
      // Dispatch Thread, otherwise we get a race condition
      // between the constructor (running in the main() thread)
      // and the very first ComponentEvent (running in the EDT).
      javax.swing.SwingUtilities.invokeLater(
         new Runnable() // an anonymous inner class constructor
         {
            public void run() // implement the Runnable interface
            {
               // call the constructor that builds the gui
               new InteractiveSierpinskiTriangle_R18("Renderer 18", width, height);
            }
         }
      );
   }//main()


   private static void print_help_message()
   {
      System.out.println("Use the 'd' key to toggle debugging information on and off.");
      System.out.println("Use the 'p' key to toggle between parallel and orthographic projection.");
      System.out.println("Use the x/X, y/Y, z/Z, keys to translate the sponge along the x, y, z axes.");
      System.out.println("Use the u/U, v/V, w/W, keys to rotate the sponge around the x, y, z axes.");
      System.out.println("Use the s/S keys to scale the size of the sponge.");
      System.out.println("Use the 'c' key to change the random solid sponge color.");
      System.out.println("Use the 'C' key to randomly change sponge's colors.");
      System.out.println("Use the 'e' key to change the random solid primitive colors.");
      System.out.println("Use the 'E' key to change the random primitive colors.");
      System.out.println("Use the 'a' key to toggle antialiasing on and off.");
      System.out.println("Use the n/N keys to move the camera's near plane.");
      System.out.println("Use the f/F keys to move the camera's far plane.");
      System.out.println("Use the o/O keys to change the size of the camera's view rectangle.");
      System.out.println("Use the r/R keys to change the aspect ratio of the camera's view rectangle.");
      System.out.println("Use the 'D' key to decouple the perspective camera's view volume from near.");
      System.out.println("Use the 'l' key to toggle letterboxing on and off.");
      System.out.println("Use the arrow keys to move the camera location left/right and up/down.");
      System.out.println("Use CTRL arrow keys to rotate the camera left/right and up/down.");
      System.out.println("Use the 'm' key to toggle showing the Model transformation matrix.");
      System.out.println("Use the 'M' key to toggle showing the Camera normalization matrix.");
      System.out.println("Use the 1/!, 2/@, 3/#, keys to rotate the sub-sponges around the x, y, z axes.");
      System.out.println("Use the 'g' key to toggle back face culling.");
      System.out.println("Use the 'G' key to toggle CW vs CCW.");
      System.out.println("Use the 't' key to toggle two sided faces.");
      System.out.println("Use the 'P' key to convert the current model to a point cloud.");
      System.out.println("Use the '4' key to change the random solid sub-sponge colors.");
      System.out.println("Use the ' ' key to toggle between the image buffer and z-buffer.");
      System.out.println("Use the 'h' key to redisplay this help message.");
   }

   private static void setBackFaceCulling(Position p, boolean doBackFaceCulling)
   {
      if (null != p.model)
      {
         p.model.setBackFaceCulling(doBackFaceCulling);
      }
      for (Position p2 : p.nestedPositions)
      {
         setBackFaceCulling(p2, doBackFaceCulling);
      }
   }


   private static void setFrontFacingIsCCW(Position p, boolean frontFacingIsCCW)
   {
      if (null != p.model)
      {
         p.model.setFrontFacingIsCCW(frontFacingIsCCW);
      }
      for (Position p2 : p.nestedPositions)
      {
         setFrontFacingIsCCW(p2, frontFacingIsCCW);
      }
   }


   private static void setFacesHaveTwoSides(Position p, boolean facesHaveTwoSides)
   {
      if (null != p.model)
      {
         p.model.setFacesHaveTwoSides(facesHaveTwoSides);
      }
      for (Position p2 : p.nestedPositions)
      {
         setFacesHaveTwoSides(p2, facesHaveTwoSides);
      }
   }
}
