/*

*/

package renderer.models_F;
import  renderer.scene.*;
import  renderer.scene.primitives.*;

/**
   Create a wireframe model of a cube with its center
   at the origin, having edge length 2, and with its
   vertices at {@code (1, 1, 1)}.
<p>
   Here is a picture showing how the cube's eight vertices
   are labeled.
<pre>{@code
                  v[4]
                   +-----------------+ v[5]
                  /|                /|
                /  |              /  |
              /    |            /    |
            /      |          /      |
      v[7] +-----------------+ v[6]  |
           |       |         |       |               y
           |       |         |       |               |
           |       |         |       |               |
           |  v[0] +---------|-------+ v[1]          |
           |      /          |      /                |
           |    /            |    /                  +----. x
           |  /              |  /                   /
           |/                |/                    /
           +-----------------+                    /
          v[3]              v[2]                 z
}</pre>
   See <a href="http://en.wikipedia.org/wiki/Cube" target="_top">
                http://en.wikipedia.org/wiki/Cube</a>

   @see Tetrahedron
   @see Octahedron
   @see Icosahedron
   @see Dodecahedron
*/
public class Cube extends Model
{
   /**
      Create a cube with its center at the origin, having edge
      length 2, and with its vertices at {@code (1, 1, 1)}.
   */
   public Cube( )
   {
      super();

      // Create the cube's geometry.
      Vertex v0 = new Vertex(-1, -1, -1); // four vertices around the bottom face
      Vertex v1 = new Vertex( 1, -1, -1);
      Vertex v2 = new Vertex( 1, -1,  1);
      Vertex v3 = new Vertex(-1, -1,  1);
      Vertex v4 = new Vertex(-1,  1, -1); // four vertices around the top face
      Vertex v5 = new Vertex( 1,  1, -1);
      Vertex v6 = new Vertex( 1,  1,  1);
      Vertex v7 = new Vertex(-1,  1,  1);

      // Add the cube's vertices to the model.
      addVertex(v0, v1, v2, v3);
      addVertex(v4, v5, v6, v7);

      // Create the 6 faces of the cube.
      // bottom face
      addPrimitive(new Face(0, 1, 2, 3));
      // front face
      addPrimitive(new Face(3, 2, 6, 7));
      // right face
      addPrimitive(new Face(2, 1, 5, 6));
      // back face
      addPrimitive(new Face(1, 0, 4, 5));
      // left face
      addPrimitive(new Face(0, 3, 7, 4));
      // top face
      addPrimitive(new Face(7, 6, 5, 4));
   }
}//Cube
