/*

*/

package renderer.models_T;
import  renderer.scene.*;
import  renderer.scene.primitives.*;

/**
   Create a solid model of a cube with its center
   at the origin, having edge length 2, and with its
   vertices at {@code (1, 1, 1)}.
<p>
   Here is a picture showing how the cube's eight vertices
   are labeled.
<pre>{@code
                  v[4]
                   +-----------------+ v[5]
                  /|                /|
                /  |              /  |
              /    |            /    |
            /      |          /      |
      v[7] +-----------------+ v[6]  |
           |       |         |       |               y
           |       |         |       |               |
           |       |         |       |               |
           |  v[0] +---------|-------+ v[1]          |
           |      /          |      /                |
           |    /            |    /                  +----. x
           |  /              |  /                   /
           |/                |/                    /
           +-----------------+                    /
          v[3]              v[2]                 z
}</pre>
   See <a href="http://en.wikipedia.org/wiki/Cube" target="_top">
                http://en.wikipedia.org/wiki/Cube</a>

   @see Tetrahedron
   @see Octahedron
   @see Icosahedron
   @see Dodecahedron
*/
public class Cube extends Model
{
   /**
      Create a cube with its center at the origin, having edge
      length 2, and with its vertices at {@code (1, 1, 1)}.
   */
   public Cube( )
   {
      super();

      // Create the cube's geometry.
      Vertex v0 = new Vertex(-1, -1, -1); // four vertices around the bottom face
      Vertex v1 = new Vertex( 1, -1, -1);
      Vertex v2 = new Vertex( 1, -1,  1);
      Vertex v3 = new Vertex(-1, -1,  1);
      Vertex v4 = new Vertex(-1,  1, -1); // four vertices around the top face
      Vertex v5 = new Vertex( 1,  1, -1);
      Vertex v6 = new Vertex( 1,  1,  1);
      Vertex v7 = new Vertex(-1,  1,  1);

      // Add the cube's vertices to the model.
      addVertex(v0, v1, v2, v3);
      addVertex(v4, v5, v6, v7);

      // Create 12 triangles, 2 for each face of the cube.

      addPrimitive(new Triangle(0, 1, 2),  // bottom face
                   new Triangle(2, 3, 0),
                   new Triangle(3, 2, 6),  // front face
                   new Triangle(6, 7, 3),
                   new Triangle(2, 1, 5),  // right face
                   new Triangle(5, 6, 2),
                   new Triangle(1, 0, 4),  // back face
                   new Triangle(4, 5, 1),
                   new Triangle(0, 3, 7),  // left face
                   new Triangle(7, 4, 0),
                   new Triangle(7, 6, 5),  // top face
                   new Triangle(5, 4, 7));
   }
}//Cube
