/*

*/

package renderer.models_TP;
import  renderer.scene.*;
import  renderer.scene.primitives.*;

/**
   Create a solid model of a cube with its center
   at the origin, having edge length 2, and with its
   vertices at {@code (1, 1, 1)}.
<p>
   Here is a picture showing how the cube's eight vertices
   are labeled.
<pre>{@code
                  v[4]
                   +-----------------+ v[5]
                  /|                /|
                /  |              /  |
              /    |            /    |
            /      |          /      |
      v[7] +-----------------+ v[6]  |
           |       |         |       |               y
           |       |         |       |               |
           |       |         |       |               |
           |  v[0] +---------|-------+ v[1]          |
           |      /          |      /                |
           |    /            |    /                  +----. x
           |  /              |  /                   /
           |/                |/                    /
           +-----------------+                    /
          v[3]              v[2]                 z
}</pre>
   See <a href="http://en.wikipedia.org/wiki/Cube" target="_top">
                http://en.wikipedia.org/wiki/Cube</a>

   @see Tetrahedron
   @see Octahedron
   @see Icosahedron
   @see Dodecahedron
*/
public class Cube extends Model
{
   /**
      Create a cube with its center at the origin, having edge
      length 2, and with its vertices at {@code (1, 1, 1)}.
   */
   public Cube( )
   {
      super();

      // Create the cube's geometry.
      Vertex v0 = new Vertex(-1, -1, -1); // four vertices around the bottom face
      Vertex v1 = new Vertex( 1, -1, -1);
      Vertex v2 = new Vertex( 1, -1,  1);
      Vertex v3 = new Vertex(-1, -1,  1);
      Vertex v4 = new Vertex(-1,  1, -1); // four vertices around the top face
      Vertex v5 = new Vertex( 1,  1, -1);
      Vertex v6 = new Vertex( 1,  1,  1);
      Vertex v7 = new Vertex(-1,  1,  1);

      // Add the cube's vertices to the model.
      addVertex(v0, v1, v2, v3);
      addVertex(v4, v5, v6, v7);

      //  https://stackoverflow.com/questions/28375338/cube-using-single-gl-triangle-strip
      //  http://www.cs.umd.edu/gvil/papers/av_ts.pdf

      // Create 12 triangles, 2 for each face of the cube.
      addPrimitive(new TriangleStrip(0, 1, 3, 2));  // bottom face
      addPrimitive(new TriangleStrip(2, 6, 3, 7));  // front face
      addPrimitive(new TriangleStrip(1, 5, 2, 6));  // right face
      addPrimitive(new TriangleStrip(0, 4, 1, 5));  // back face
      addPrimitive(new TriangleStrip(0, 3, 4, 7));  // left face
      addPrimitive(new TriangleStrip(4, 7, 5, 6));  // top face
   }
}//Cube
