/*

*/

package renderer.pipeline;
import  renderer.scene.*;
import  renderer.scene.primitives.*;

import java.util.List;

/**
   Clip a (projected) geometric {@link Primitive} that sticks out of the
   view rectangle in the image plane. Interpolate {@link Vertex}
   color from any clipped off {@link Vertex} to the new {@link Vertex}.
*/
public class Clip
{
   public static boolean debug = false;

   /**
      If the {@link Primitive} sticks out of the view rectangle,
      then clip it so that it is contained in the view rectangle.

      @param model  {@link Model} that the {@link Primitive} comes from
      @param p      {@link Primitive} to be clipped
      @return a list that is either empty or contains clipped {@link Primitive}s
   */
   public static List<Primitive> clip(Model model, Primitive p)
   {
      List<Primitive> result = java.util.Collections.emptyList();

      if (p instanceof Triangle)
      {
         result = ClipTriangle.clip(model, (Triangle)p);
      }
      else if (p instanceof LineSegment)
      {
         result = ClipLine.clip(model, (LineSegment)p);
      }
      else
      {
         result = ClipPoints.clip(model, (Points)p);
      }

      return result;
   }
}
