/*

*/

package renderer.pipeline;
import  renderer.scene.*;
import  renderer.scene.primitives.*;

import java.util.List;
import java.util.ArrayList;

/**
   Clip a (projected) {@link Points} that sticks out
   of the view rectangle in the image plane.
*/
public class ClipPoints
{
   /**
      If any {@link Vertex} used by this {@link Points} sticks out
      of the view rectangle, then delete that vertex's index from
      the {@link Points}'s vetex and color lists.

      @param model  {@link Model} that the {@link Points} {@code pts} comes from
      @param pts  {@link Points} to be clipped
      @return a list that is either empty or contains the clipped {@link Points}
   */
   public static List<Primitive> clip(Model model, Points pts)
   {
      boolean debug = Clip.debug;

      List<Primitive> result = new ArrayList<>();

      Points clippedPoints = new Points();
      clippedPoints.radius = pts.radius;

      for (int i = 0; i < pts.vIndexList.size(); ++i)
      {
         // Make local copies of several values.
         Vertex v = model.vertexList.get(pts.vIndexList.get(i));

         double x = v.x,  y = v.y,  z = v.z,  w = v.w;

         // 1. Check for trivial accept.
         if (! (Math.abs(x) > Math.abs(w)
             || Math.abs(y) > Math.abs(w)
             || Math.abs(z) > Math.abs(w)))//Same clipping eqn as in last
         {                                 //renderer, but for different reason
            clippedPoints.addIndices(pts.vIndexList.get(i),
                                     pts.cIndexList.get(i));

            if (debug) System.out.println(" Trivial accept: " + pts.vIndexList.get(i));

         }
         // 2. Trivial delete.
         else
         {
            if (debug) System.out.println(" Trivial delete: " + pts.vIndexList.get(i));
         }
      }

      if (! clippedPoints.vIndexList.isEmpty())
      {
         result.add(clippedPoints);
      }

      return result;
   }
}
