/*

*/

package renderer.pipeline;
import  renderer.scene.*;

import java.util.List;

/**
   Transform each {@link Vertex} of a {@link Model} from the
   model's (private) local coordinate system to the (shared)
   world coordinate system.
<p>
   For each {@code Vertex} object in a {@code Model} object,
   use the current transformation {@link Matrix} to transform the
   {@code Vertex} object's coordinates from the model's coordinate
   system to the world coordinate system.
*/
public class Model2World
{
   /**
      Use the current transformation {@link Matrix} to transform each
      {@link Vertex} from a {@link Model}'s coordinate system to the
      world coordinate system.

      @param vertexList  {@link List} of {@link Vertex} objects to transform into world coordinates
      @param ctm         the current transformation {@link Matrix}
   */
   public static void model2world(List<Vertex> vertexList, Matrix ctm)
   {
      // Mutate each Vertex object so that it contains
      // world coordinates.
      for (Vertex v : vertexList)
      {
         v.times(ctm);
      }
   }
}
