/*

*/

package renderer.pipeline;
import  renderer.scene.*;

import java.util.List;

/**
   Do perspective division of a {@link Vertex} in homogeneous
   coordinates,
   <pre>{@code
      (x, y, z, w) -> (x/w, y/w, z/w, 1).
   }</pre>
   <p>
   This completes the projection operation that was only
   partially done by the {@link Camera}'s projection
   {@link Matrix}. This stage of the pipeline leaves
   vertices lying in the normailized device coordinate space.
*/
public class PerspectiveDivision
{
   /**
      For each {@link Primitive}, do the perspective
      division operation on each {@link Vertex}.

      @param p  {@link List} of {@link Vertex} objects to project from homogeneous clip space into NDC
   */
   public static void perspectiveDivide(List<Vertex> vertexList)
   {
      // Mutate each Vertex object so that it contains
      // its perspective division.
      for (Vertex v : vertexList)
      {
         v.perspectiveDivision();
      }
   }
}
