/*

*/

package renderer.pipeline;
import  renderer.scene.*;

import java.util.List;

/**
   Transform each {@link Vertex} of a {@link Model} from the
   camera coordinate system to the homogeneous clip coordinate
   system.
<p>
   For each {@code Vertex} object in a {@code Model} object,
   use the {@link Camera}'s projection {@link Matrix} to
   transform the {@code Vertex} object's coordinates from the
   (normalized) camera space {@link w = 1}.to the homogeneous
   clip space {@link z + w = 0}.
<p>
   Recall that the {@code Camera}'s projection {@code Matrix}
   does not complete the projection operation (the vertices
   are not yet in normalized device coordinates). Another step
   in the pipeline, {@link PerspectiveDivision}, completes the
   projection operation to NDC.
*/
public class Projection
{
   /**
      Use a {@link Camera}'s projection {@link Matrix} to project
      each {@link Vertex} into the homogeneous space {@link z + w = 0}.

      @param vertexList  {@link List} of {@link Vertex} objects to project onto the image plane
      @param camera      a reference to the {@link Scene}'s {@link Camera} object
   */
   public static void project(List<Vertex> vertexList, Camera camera)
   {
      Matrix projMatrix = camera.projMatrix;

      // Mutate each Vertex object so that it contains
      // homogeneous clip coordinates.
      for (Vertex v : vertexList)
      {
         v.times(projMatrix);
      }
   }
}
