/*

*/

package renderer.pipeline;
import  renderer.scene.*;
import  renderer.scene.primitives.*;
import  renderer.framebuffer.*;

/**
   Rasterize a geometric {@link Primitive} into
   pixels in the {@link FrameBuffer}'s viewport.
*/
public class Rasterize
{
   public static boolean debug = false;

   /**
      Rasterize a {@link Primitive} into pixels in the
      {@link FrameBuffer}'s viewport.

      @param model  {@link Model} that the {@link Primitive} comes from
      @param p      {@code Primitive} to rasterize into the {@code FrameBuffer}
      @param fb     {@code FrameBuffer} to hold rasterized pixels
   */
   public static void rasterize(Model model, Primitive p, FrameBuffer fb)
   {
      if (p instanceof Triangle)
      {
         RasterizeTriangle.rasterize(model, (Triangle)p, fb);
      }
      else if (p instanceof LineSegment)
      {
         RasterizeLine.rasterize(model, (LineSegment)p, fb);
      }
      else
      {
         RasterizePoints.rasterize(model, (Points)p, fb);
      }
   }
}
