/*

*/

package renderer.pipeline;
import  renderer.scene.*;

import java.util.List;

/**
   Transform each {@link Vertex} of a {@link Model} from the
   world coordinate system to the {@link Camera}'s view
   coordinate system.
<p>
   For each {@code Vertex} object in a {@code Model} object,
   use the {@link Camera}'s view {@link Matrix} to transform the
   {@code Vertex} object's coordinates from the world coordinate
   system to the view coordinate system.
*/
public class World2View
{
   /**
      Use a {@link Camera}'s world-to-view {@link Matrix} to transform
      each {@link Vertex} from the world coordinate system to the camera's
      view coordinate system.

      @param vertexList  {@link List} of {@link Vertex} objects to transform into view coordinates
      @param camera      a reference to the {@link Scene}'s {@link Camera} object
   */
   public static void world2view(List<Vertex> vertexList, Camera camera)
   {
      Matrix viewMatrix = camera.viewMatrix;

      // Mutate each Vertex object so that it contains
      // view coordinates.
      for (Vertex v : vertexList)
      {
         v.times(viewMatrix);
      }
   }
}
